% EDCC2026 poster template, October 2026
% Based on the EDCC 2024 template, which is again based on kuleuventheme2poster by Janez Kren, June 2018

\ProvidesClass{EDCC26_poster}[2025/01/13 Poster class for EDCC 2026]

\DeclareOption{shortTitle}{\providecommand{\titlearea}{\begin{tikzpicture}
    \node [text width=\textwidth, text ragged, inner sep=0pt, outer sep=0, execute at begin node=\setlength{\baselineskip}{0.8em}, \primaryColor, font=\bfseries\fontsize{0.6\baseh pt}{2}\selectfont] 	
    { \inserttitle } ;
    \end{tikzpicture}}
}
\DeclareOption{longTitle}{\renewcommand{\titlearea}{
    \textcolor{\primaryColor}{\bfseries \Huge \inserttitle}
}
}
\DeclareOption{noTitle}{\renewcommand{\titlearea}{ \vspace{-.3\baseh}} }

\DeclareOption{portrait}{\providecommand{\orientation}{portrait}}
\DeclareOption{landscape}{\renewcommand{\orientation}{landscape}}
\ExecuteOptions{shortTitle, portrait}
\ProcessOptions\relax

\newcommand{\primaryColor}{kul-blue}
\newcommand{\secondaryColor}{kul-secblue}
\newcommand{\darkColor}{kul-dark}
\newcommand{\lightColor}{kul-light}
\newcommand{\backgroundColor}{kul-secblue}
\newcommand{\backgroundOpacity}{1}


\newcommand{\setPrimaryColor}[1]{\renewcommand{\primaryColor}{#1}}
\newcommand{\setSecondaryColor}[1]{\renewcommand{\secondaryColor}{#1}}
\newcommand{\setDarkColor}[1]{\renewcommand{\darkColor}{#1}}
\newcommand{\setLightColor}[1]{\renewcommand{\lightColor}{#1}}
\newcommand{\setBackgroundColor}[1]{\renewcommand{\backgroundColor}{#1}}
\newcommand{\setBackgroundOpacity}[1]{\renewcommand{\backgroundOpacity}{#1}}


\newcommand{\backgroundImage}[1]{\titlegraphic{#1}}
\newcommand*{\email}[1]{\def\insertemail{#1}}

\LoadClass{beamer}
\RequirePackage[orientation=\orientation,size=a0,scale=1.8]{beamerposter}
\RequirePackage[utf8]{inputenc}
\RequirePackage{ragged2e}
\RequirePackage{ifthen}
\RequirePackage{tikz}
\usetikzlibrary{shapes,shadows,arrows,backgrounds,mindmap,decorations.pathreplacing,positioning}
\RequirePackage{listings}
\RequirePackage{lstautogobble}
\lstdefinestyle{default}{
    basicstyle=\ttfamily,
    basewidth=.5em,
    tabsize=2
}
\lstset{style=default}


% Default colors
\definecolor{kul-blue}		{RGB}{29,141,176}		%KUL primary blue
\definecolor{kul-secblue}	{RGB}{220,231,240}		%KUL secondary gray-blue
\definecolor{kul-dark}		{RGB}{47,77,93}			%KUL dark blue 
\definecolor{kul-light}		{RGB}{82,189,236}		%KUL light blue 
\definecolor{gray}			{gray}{.5}				%gray
\definecolor{lgray}			{gray}{.95}				%light gray for backgrounds

\date{8--11 April 2025}

\newlength\baseh %base size
\setlength{\baseh}{0.072\paperheight\relax}  % adjust coefficent to rescale

% \usetheme{EDCC2025}
%% THEME
\mode<presentation>

% Text colours
\hypersetup{colorlinks,linkcolor=\primaryColor,urlcolor=\primaryColor} %link colors
\urlstyle{sf}					%url addreses are sans-serif font (not typewritter)
        
\setbeamercolor{normal text}	{fg=black}			        %text color
\setbeamercolor{frametitle}		{fg=\primaryColor}			%frame title color
\setbeamercolor{section in toc} {fg=\primaryColor}			%toc (section) color
\setbeamercolor{section in toc shaded}{fg=\primaryColor}		%toc (shaded section) color
\setbeamercolor{item}			{fg=\primaryColor}			%item color
\setbeamercolor{subitem}		{fg=\primaryColor}			%subitem color
\setbeamercolor{subsubitem}		{fg=\primaryColor}			%subsubitem color
\setbeamercolor{text}			{fg=white,bg=\primaryColor}	%text block color
\setbeamercolor{caption name}	{fg=black}				    %figure and table caption color
\setbeamercolor{abstract title}	{fg=\primaryColor}			%abstract title color

% Blocks, theorem-like environments and colorboxes
\setbeamerfont{block title} {size=\normalsize}				%block title font size

\setbeamercolor{block title}{bg=lgray,fg=\primaryColor}		%block title color
\setbeamercolor{block body} {bg=lgray,fg=black}				%block body color


\setbeamertemplate{qed symbol}{\color{\primaryColor} $\square$}	%end of proof symbol

\setbeamercolor{block title alerted}{bg=white!95!red}				%alertbloc title (red)
\setbeamercolor{block body alerted}{bg=white!95!red}				%alertbloc body

\setbeamercolor{block title example}{bg=white!95!\primaryColor,fg=\primaryColor} 	%example block title (blue)
\setbeamercolor{block body example}{bg=white!95!\primaryColor,fg=black}		        %example block body

%five different color schemes for Beamer color box:
\setbeamercolor{primary}	{fg=white,bg=\primaryColor}		
\setbeamercolor{primary2}	{fg=\primaryColor,bg=lgray}
\setbeamercolor{secondary}	{fg=white,bg=\secondaryColor}		
\setbeamercolor{secondary2}	{fg=\secondaryColor,bg=lgray}
\setbeamercolor{light}	    {fg=white,bg=\lightColor}		
\setbeamercolor{light2}	    {fg=\lightColor,bg=lgray}
\setbeamercolor{dark}	    {fg=white,bg=\darkColor}		
\setbeamercolor{dark2}	    {fg=\darkColor,bg=lgray}
\setbeamercolor{lgray}		{fg=black,bg=lgray}
\setbeamercolor{alert}		{fg=white,bg=red}	
\setbeamercolor{alert2}		{fg=red,bg=lgray}


%%		
%%  INNER THEME
%%
\setbeamertemplate{sections/subsections in toc}[circle]			        %toc symbols
\setbeamersize{text margin left=.5\baseh,text margin right=.5\baseh} 	%text margins

%itemize list
    \setbeamertemplate{itemize item}[triangle] 			%item symbol (triangle)
    \setbeamertemplate{itemize subitem}[circle]			%subitem symbol (cirlce)
    \renewcommand\textbullet{\ensuremath{\bullet}}		%correction for warning for subitem circle bullect
    \setbeamertemplate{itemize subsubitem}{-}			%subsubitem symbol (short hypthen)

%enumerate list
    \setbeamertemplate{enumerate item}{\small  \insertenumlabel  \enspace }		                %enumerate symbol
    \setbeamertemplate{enumerate subitem}{\scriptsize \raisebox{.085em} \insertsubenumlabel } 	%subenumerate symbol
    \setbeamertemplate{enumerate subsubitem}{\tiny \raisebox{.18em} \insertsubsubenumlabel } 	%subenumerate symbol


%%		
%%  OUTER THEME
%%
\setbeamertemplate{navigation symbols}{} %remove the navigation symbols


\setbeamertemplate{headline}{
    \begin{tikzpicture}[remember picture,overlay]
        % main background
        \fill [color=\backgroundColor]
            (current page.north west)   rectangle   (current page.south east);

        % top blue background band
        \fill [color=kul-blue]
            (current page.north west)   rectangle   ([shift={(0,-2\baseh)}]current page.north east);
        
        % top background band
        \fill [color=kul-secblue]
            (current page.north west)   rectangle   ([shift={(0,-0.9\baseh)}]current page.north east);

        % title graphic (optional, will overlay main background)
        \node [anchor=north west,yshift=-2\baseh,inner sep=0pt, opacity=\backgroundOpacity]
            at (current page.north west) 
            {\inserttitlegraphic};

        % logo
        \node [anchor=north west,xshift=0.5\baseh,yshift=-.5\baseh,inner sep=0pt] 
            at (current page.north west) 
            {\includegraphics[height=\baseh]{graphics/logo.png}};

        % info box
        \node [white, align= flush right, text width=.65\paperwidth, text depth=0pt,
            anchor=north east, xshift=-0.5\baseh, yshift=-1.1\baseh] 
            at (current page.north east) {
            \large
            \ifthenelse{\equal{\orientation}{portrait}} {
                % portrait mode:
                \insertauthor			

                \vspace{2pt} 
                \insertinstitute
                
                \vspace{2pt} 
                \insertemail
            } {
                % landscape mode:
                \insertauthor		

                \vspace{2pt} 
                \insertinstitute~--~\insertemail
            }
  
            
        };	
        \end{tikzpicture}	
    
    }

\setbeamertemplate{frametitle}{}

\mode
<all> 


\let\olddocument\document
\let\oldenddocument\enddocument

\renewenvironment{document}{
    \olddocument\begin{frame}[t, fragile=singleslide]
    \csname beamer@calculateheadfoot\endcsname
    \vspace{2.5\baseh}
    
    \titlearea
    
    \vspace{.3\baseh}

}{
    \end{frame}\oldenddocument
}
