-- 	Actor.hs
--	September 1999

module Actor where

import Fran

-- 	The actor problem in its final version.


scenario :: User -> ImageB

scenario u
  = actor
      `over`
    phone
      `over`
    back

    where
    actor :: ImageB

    actor
      = move actorPath actorImage

    actorPath :: Vector2B 

    actorPath 
       = startPos `switcher`  
         (startMove -=> (motion `switcher` 
         (endMove   -=> endPos)))

    motion = vector2XY xPos yPos
    yPos   = yStart + atRateU 0.05		-- could also implement using 
						-- 0.05*(time - constantB (ust + 10))

    startMove = makeEvent [10]
    endMove   = predicateU (yPos >=* yEnd)


    actorImage :: ImageB

    actorImage
      = man 
          `over`
        wordsImage
          `over`
        bubbleImage

    wordsImage :: ImageB

    wordsImage = moveXY 0.42 0.64 (withColor blue (stringBIm words))

    words 
      = stepper ""
        (actorsLine
         .|.
         startMove -=> ""
         .|.
         endMove -=> "Hello")

    actorsLine 
      = makeEventVals
            [2.5,3.5 .. ] 
            ["Now","is","the","winter","of","our","discontent."]
  
    bubbleImage 
      = emptyImage 
         `switcher`
           (makeEvent [1] -=> bubble
            .|.
            startMove     -=> emptyImage
            .|.
            endMove       -=> bubble)

    phone :: ImageB
 
    phone = moveXY 0.6 0.7 $
            phoneOff 
             `switcher`
             (startMove -=> ringingPhone 
              .|.
              endMove   -=> liftedPhone)

    ringOn, ringOff :: Event ()
    ringOn  = makeEventRelEvent startMove [2,4 .. 8]
    ringOff = makeEventRelEvent startMove [1,3 .. 9]

    ringingPhone 
      = phoneOn
         `switcher` 
          (ringOn  -=> phoneOn
           .|.
           ringOff -=> phoneOff)


--  Auxiliary stuff factoring out all the uses of User into versions of
--  with the User already supplied. These come within the where clause.

    predicateU = flip predicate u	
    ust        = userStartTime u 	
    atRateU    = flip atRate u		
					
-- Auxiliary functions to make an (Event a) from a list of times and
-- a list of values and an Event () from a list of times.

    makeEventVals :: [Time] -> [a] -> Event a

    makeEventVals ts xs = possOccsE (zip (map (+ust) ts) (map Just xs))

    makeEvent :: [Time] -> Event ()

    makeEvent = makeEventRel ust

-- Two other auxiliary event-making functions. These don't use User
-- information and so are not included in the where clause.

-- makeEventRel makes an event from a list of occurence times plus
-- a starting time.

makeEventRel :: Double -> [Double] -> Event ()

makeEventRel t  
  = foldr (.|.) neverE . (map (timeIs . (t +)))


-- makeEventRelEvent is makeEventRel started at the first occurrence of
-- the event which is the first argument of the function.

makeEventRelEvent :: Event () -> [Double] -> Event ()

makeEventRelEvent ev ts
  = joinEOne (handleE ev (\t _ _ -> makeEventRel t ts))


-- The constant images, including (scaled) bitmap images and the background.

phoneOn, phoneOff, base, handset, man, bubble :: ImageB

phoneOff    = importBitmap "c:/hugswork/Sept99/phone0.bmp"
phoneOn     = importBitmap "c:/hugswork/Sept99/phone1.bmp"
base        = importBitmap "c:/hugswork/Sept99/base.bmp"
handset     = moveXY 0 0.2 (importBitmap "c:/hugswork/Sept99/handset.bmp")
liftedPhone = handset `over` base          
man         = stretch 0.3 (importBitmap "c:/hugswork/Sept99/man.bmp")
bubble      = moveXY 0.4 0.6 (stretch 0.5 (importBitmap "c:/hugswork/Sept99/bubble.bmp"))

back = withColor (duller 0.05 yellow) (stretch 2.0 circle)

-- System geometry

xPos     = constantB (-0.4)
yStart   = constantB (-0.55)
yEnd     = constantB 0.45
startPos = vector2XY xPos yStart
endPos   = vector2XY xPos yEnd


