
--	Display2.hs

--	Displaying real behaviours as in Sect 6.2 of `Modelling Reactive 
--	Multimedia: Events & behaviours' by Helen Cameron, Peter King 
--	and Simon Thompson.

module Display2 where

import Fran
import Display1		-- for showBar

-- Display some history with ten showBars, showing the behaviour over
-- a two second window.

historyDisplay :: RealB -> ImageB

historyDisplay beh
  = foldr1 over (map (moveIt bar) [0,0.2 .. 2.0])
    where
    bar = showBar beh

--  Moving a single bar in space and time.  The construction is more
--  general than that used in the paper since can apply both later and
--  moveXY to real behaviours - that is changing offsets - rather than
--  to simple constant offsets as used here.

moveIt :: ImageB -> Double -> ImageB

moveIt image r
  = later r' (moveXY (0.9-r') 0 image)
    where
    r' = constantB r


-- Test historyDisplay

test2 = display (withColor white (historyDisplay (slower 8 wiggle)))



