

--	Display3.hs

--	Displaying real behaviours as in Sect 6.3 of `Modelling Reactive 
--	Multimedia: Events & behaviours' by Helen Cameron, Peter King 
--	and Simon Thompson.

module Display3 where

import Fran

import qualified Display1		-- for Display1.showBar
import qualified Display2		-- for Display2.moveIt


--  The original definition of showBar from Sectinos 6.1 and 6.2.

showBar' = Display1.showBar

-- The new definition of showBar

showBar :: RealB -> User -> ImageB

showBar beh u
  = withColor (changeCol beh u) (showBar' beh)

--  historyDisplay: redefined to take a User argument.

historyDisplay :: RealB -> User -> ImageB

historyDisplay beh u
  = foldr1 over (map (moveIt bar) [0,0.2 .. 2.0])
    where
    bar = showBar beh u

moveIt = Display2.moveIt

-- Test historyDisplay

test3 = displayU (historyDisplay (slower 8 wiggle))

-- Spotting a maximum point in a real behaviour

spotMax :: RealB -> BoolB

spotMax beh
  = (beh <* beh1) &&* (beh2 <* beh1)
    where
    beh1 = later 0.2 beh
    beh2 = later 0.4 beh

maxEvent :: RealB -> User -> Event ()

maxEvent beh u = predicate (spotMax beh) u

-- Spotting a minimum point in a real behaviour

spotMin :: RealB -> BoolB

spotMin beh
  = (beh >* beh1) &&* (beh2 >* beh1)
    where
    beh1 = later 0.2 beh
    beh2 = later 0.4 beh

minEvent :: RealB -> User -> Event ()

minEvent beh u = predicate (spotMin beh) u

-- Changing colour according to maximum...

changeCol :: RealB -> User -> ColorB

changeCol beh u
  = white `switcher`
      (minEvent beh u -=> red
       .|.
       maxEvent beh u -=> blue) 



