

--	Encyclopedia.hs

--	A reactive web page, which depends upon external behaviours to
-- 	give its form. The idea was to build something putting together
--	the monitor and tickertape ideas in a single case study.

--	NB INCOMPLETE

--	SJT 16.9.99


module Encyclopedia where

import Fran
import Tickertape				-- for ticker
import Monitor3
-- import qualified StaticTypes as S		-- for Font etc.
-- import List					-- for intersperse

-- The top level display.

topLevel :: User -> ImageB

topLevel u 
  = tickerTape
    `over`
    title
    `over`
    overLap
    `over`
    graph

overLap :: ImageB

overLap = toggleOver togEv 

title :: ImageB

title = moveXY (-0.52) 1 $
        withColor white $
        stringIm "Multipedia 2000"

tickerTape :: ImageB

tickerTape= mask `over`
            moveXY 0 (-0.9) (ticker ttInput) `over`
            background
            where
            background =
              (withColor yellow $
              polygon [ point2XY (-2) (-0.98) , 
              point2XY 2 (-0.98) , 
              point2XY 2 (-0.8) , 
              point2XY (-2) (-0.8) ])
            mask = 
              (withColor black $
              polygon [ point2XY (-2) (-0.98) , 
              point2XY (-20) (-0.98) , 
              point2XY (-20) (-0.8) , 
              point2XY (-2) (-0.8) ])
              `over`
              (withColor black $
              polygon [ point2XY (2) (-0.98) , 
              point2XY (20) (-0.98) , 
              point2XY (20) (-0.8) , 
              point2XY (2) (-0.8) ])
              

-- A test Event built from scratch simulating tickertape input.

ttInput :: Event String

ttInput 
  = possOccsE $ zip times (map Just words)
            where
            words = concat (repeat ["Late","breaking","information","about","the","eruption","in","Iceland."])
            times = makeNums 10.0 [1.0,1.1,2.0,2.1,2.2,5.0,6.0,8.9,9.0,10.0]
            makeNums n ns = ns ++ makeNums n (map (+n) ns)




