

--	Monitor.hs

--	Monitoring the values of a RealB: and in particular spotting 
-- 	turning points in the behaviour of a function.

--	Started off as a modification of Monitor.hs written in Sept 1998.

--	SJT 14.9.99


module Monitor where

import Fran

-- Line above the origin in the y-direction showing the magnitude of 
-- a RealB

showLine :: RealB -> User -> ImageB

showLine beh u
  = withColor (changeCol beh u) $
    polygon [ (point2XY 0 0) , 
              (point2XY 0 beh) , 
              (point2XY delta beh) , 
              (point2XY delta 0) ]

-- Width of the line.

delta = constantB 0.08

-- Display some history with ten showLines, showing the behaviour over
-- a two second window.

historyDisplay :: RealB -> User -> ImageB

historyDisplay beh u
  = foldr1 over (map moveIt (map constantB [0,0.2 .. 2.0]))
    where
    line = showLine beh u
    moveIt r = later r (moveXY (0.9-r) 0 line)

-- Test historyDisplay

testIt = displayU (historyDisplay (slower 8 wiggle))
testIt2 = displayU (historyDisplay 1)

-- Spotting a maximum point in a real behaviour

spotMax :: RealB -> BoolB

spotMax beh
  = (beh <* beh1) &&* (beh2 <* beh1)
    where
    beh1 = later 0.2 beh
    beh2 = later 0.4 beh

maxEvent :: RealB -> User -> Event ()

maxEvent = predicate . spotMax

-- Spotting a minimum point in a real behaviour

spotMin :: RealB -> BoolB

spotMin beh
  = (beh >* beh1) &&* (beh2 >* beh1)
    where
    beh1 = later 0.2 beh
    beh2 = later 0.4 beh

minEvent :: RealB -> User -> Event ()

minEvent = predicate . spotMin

-- Changing colour according to maximum...

changeCol :: RealB -> User -> ColorB

changeCol beh u
  = switcher white changes
    where
    changes = minEvent beh u -=> red
              .|.
              maxEvent beh u -=> blue 
{-
-- Are we at (or near) a maximum?

showMax :: RealB -> ImageB

showMax beh
    = showBIm (spotMax beh) `over` historyDisplay beh

-- Testing the spotMax function

testMax = display (showMax (slower 8 wiggle))

-}


