

--	Monitor3.hs

--	Monitoring the values of two real functions.
--	See also Monitor.hs

--	SJT 14.9.99


module Monitor3 where

import Fran

-- A line segment forming part of a graph.

showLine :: ColorB -> RealB -> ImageB

showLine col beh
  = withColor col $
    line (point2XY 0 (later delta beh)) (point2XY delta beh)
    where
    delta = constantB 0.2

-- Display some history with ten straight-line segments, showing the 
-- the behaviour of the function over a two second window.

historyDisplay :: ColorB -> RealB -> ImageB

historyDisplay col beh
  = foldr1 over (map moveIt (map constantB [0,0.2 .. 2.0]))
    where
    line = showLine col beh
    moveIt r = later r (moveXY (0.9-r) 0 line)

-- Test compareGraphs.

testIt = displayU (compareGraphs wiiggle waaggle)

-- Slower versions of wiggle and waggle.

wiiggle = slower 8 wiggle
waaggle = slower 8 waggle

-- The function compareGraphs: plot two graphs, making sure that the
-- one with the higher value is red and the lower is blue.

compareGraphs :: RealB -> RealB -> User -> ImageB

compareGraphs f g u
  = comparePlot f g u 
    `over`
    comparePlot g f u

-- Plot one of the graphs in question, using historyDisplay and
-- a colour given by compareColour.

comparePlot :: RealB -> RealB -> User -> ImageB

comparePlot f g u
  = historyDisplay (compareColour f g u) f

-- Compare the values of the two behaviours and produce the colour
-- corresponding to the first argument; i.e. red if it is the greater
-- and blue if the smaller.

compareColour :: RealB -> RealB -> User -> ColorB

compareColour f g u
  = switcher white changer
    where
    changer = changeEv f g u -=> red
              .|. 
              changeEv g f u -=> blue
    changeEv f g u = predicate (f >* g) u




