--------------------------------------------------------------------------
--                                                                      --
--	Section 2.7.: Characters and Strings				--
--                                                                      --
--	(c) Simon Thompson, 1995.					--
--                                                                      --
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--	To be Haskell 1.3 and Hugs0 compliant, the definitions		--
--									--
--		ord :: Char -> Int					--
--		ord = fromEnum						--
--									--
--		chr :: Int -> Char					--
--		chr = toEnum						--
--									--
--	need to be added to this script, since ord and chr are the	--
--	names used in 1.2 and earlier, as well as in Gofer and 		--
--	Hugs1.01.							--
--------------------------------------------------------------------------

-------------------------------------------------------------------------- 
--	The offset to convert small letters to capitals.		--
-------------------------------------------------------------------------- 

offset = ord 'A' - ord 'a'

-------------------------------------------------------------------------- 
--	 Conversion function.						--
-------------------------------------------------------------------------- 

capitalize :: Char -> Char

capitalize ch = chr (ord ch + offset)

-------------------------------------------------------------------------- 
--	Is is a isDigit?						--
--									--
--	This is problematic: isDigit is built in!			--
-------------------------------------------------------------------------- 

-- isDigit :: Char -> Bool

-- isDigit ch = ('0' <= ch) && (ch <= '9')

-------------------------------------------------------------------------- 
--	Note that in fact Strings are lists of characters.		--
-------------------------------------------------------------------------- 

-- type String = [Char]
