--------------------------------------------------------------------------
--                                                                      --
--	Chapter 3: Reasoning about programs				--
--                                                                      --
--	(c) Simon Thompson, 1995.					--
--                                                                      --
--------------------------------------------------------------------------

-------------------------------------------------------------------------- 
--	Swapping the elements of a pair.				--
-------------------------------------------------------------------------- 

swap :: (Int,Int) -> (Int,Int)

swap (a,b) = (b,a)

-------------------------------------------------------------------------- 
--	Cycling the elements of a 3-tuple.				--
-------------------------------------------------------------------------- 

cycle3,recycle3 :: (Int,Int,Int) -> (Int,Int,Int)

cycle3 (a,b,c)   = (b,c,a)
recycle3 (a,b,c) = (c,a,b)

-------------------------------------------------------------------------- 
--	Maximum of two numbers.						--
-------------------------------------------------------------------------- 

maxi :: Int -> Int -> Int

maxi n m 
  | n>=m 	= n
  | otherwise 	= m

-------------------------------------------------------------------------- 
--	Conditional swap.						--
-------------------------------------------------------------------------- 

swapIf :: (Int,Int) -> (Int,Int)

swapIf (a,b) 
  | a <= b 	= (a,b)
  | otherwise 	= (b,a)

-------------------------------------------------------------------------- 
--	Factorial.							--
-------------------------------------------------------------------------- 

fac :: Int -> Int

fac 0 = 1
fac n = n * fac (n-1)

-------------------------------------------------------------------------- 
--	Powers of two.							--
-------------------------------------------------------------------------- 

power2 :: Int -> Int

power2 0 = 1
power2 r = 2 * power2 (r-1)

-------------------------------------------------------------------------- 
--	Sums of powers of two.						--
-------------------------------------------------------------------------- 

sumPowers :: Int -> Int

sumPowers 0 = 1
sumPowers r = sumPowers (r-1) + power2 r


