--------------------------------------------------------------------------
--                                                                      --
--	Section 6.5: Generalizing: splitting up lists			--
--                                                                      --
--	(c) Simon Thompson, 1995.					--
--                                                                      --
--------------------------------------------------------------------------

-------------------------------------------------------------------------- 
--	Take and drop -- pre-defined.					--
--	take, drop :: Int -> [t] -> [t]					--
--									--
--	take n []    = []						--
--	take 0 l     = []						--
--	take n (a:x) = a : take (n-1) x					--
-------------------------------------------------------------------------- 

-------------------------------------------------------------------------- 
--	Getting elements from the front of a list until a condition 	--
--	holds.								--
-------------------------------------------------------------------------- 

getUntil :: (t -> Bool) -> [t] -> [t]

getUntil p []    = [] 
getUntil p (a:x) 
  | (p a) 		= []
  | otherwise  		= a : getUntil p x

