--------------------------------------------------------------------------
--                                                                      --
--	Appendix D: Understanding programs				--
--                                                                      --
--	(c) Simon Thompson, 1995.					--
--                                                                      --
--------------------------------------------------------------------------

-------------------------------------------------------------------------- 
--	The function in question.					--
-------------------------------------------------------------------------- 

mapWhile :: (t -> u) -> (t -> Bool) -> [t] -> [u]

mapWhile f p []    = [] 
mapWhile f p (a:x) 
  | p a 		= f a : mapWhile f p x
  | otherwise 		= []

-------------------------------------------------------------------------- 
--	Examples for evaluation.					--
-------------------------------------------------------------------------- 

exam1,exam2,exam3 :: [Int]

exam1 = mapWhile (2+) (>7) [9,12,3,13,16]
exam2 = mapWhile (2+) (>2) [9,12,3,13,16] 
exam3 = mapWhile (2+) (>2) [] 



