--------------------------------------------------------------------------
--                                                                      --
--	Section 10.1: Introduction.					--
--                                                                      --
--	(c) Simon Thompson, 1995.					--
--                                                                      --
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--	To use this in Haskell 1.3, the occurrences of the class Text	--
--	need to be replaced by Read, Show or both these classes.	--
--------------------------------------------------------------------------

-------------------------------------------------------------------------- 
--	Enumerated (weather) types.					--
-------------------------------------------------------------------------- 

data Temp   = Cold | Hot deriving (Eq,Ord,Enum,Text)

data Season = Spring | Summer | Autumn | Winter 
	      deriving (Eq,Ord,Enum,Text)

-------------------------------------------------------------------------- 
--	What is the weather?						--
-------------------------------------------------------------------------- 

weather :: Season -> Temp

weather Summer = Hot
weather _      = Cold

-------------------------------------------------------------------------- 
--	Booleans can be defined thus:					--
-- 	data Bool = False | True					--
-------------------------------------------------------------------------- 

-------------------------------------------------------------------------- 
--	Product types.							--
-------------------------------------------------------------------------- 

-------------------------------------------------------------------------- 
--	A type of people.						--
-------------------------------------------------------------------------- 

data Person = Person Name Age 

type Name   = String
type Age    = Int

exam1 = Person "Electric Aunt Jemima" 77
exam2 = Person "Ronnie" 14

-------------------------------------------------------------------------- 
--	Printing an object of type people.				--
-------------------------------------------------------------------------- 

showPerson :: Person -> String

showPerson (Person n a) = n ++ " -- " ++ show a

exam3 = showPerson (Person "Electric Aunt Jemima" 77)

-------------------------------------------------------------------------- 
--	An alternative definition of the type of people is given by 	--
--	type Person = (Name,Age)					--
-------------------------------------------------------------------------- 

-------------------------------------------------------------------------- 
--	A unary constructor						--
-------------------------------------------------------------------------- 

data NewAge = Years Int

-------------------------------------------------------------------------- 
--	Alternatives							--
-------------------------------------------------------------------------- 

-------------------------------------------------------------------------- 
--	A type of shapes.						--
-------------------------------------------------------------------------- 

data Shape = Circle Float | 
	     Rectangle Float Float 
	     deriving (Eq,Ord,Text)

exam4 = Circle 3.0
exam5 = Rectangle 45.9 87.6

-------------------------------------------------------------------------- 
--	Example functions over shape.					--
-------------------------------------------------------------------------- 

isRound :: Shape -> Bool

isRound (Circle _)      = True
isRound (Rectangle _ _) = False

area :: Shape -> Float

area (Circle r)      = pi*r*r
area (Rectangle h w) = h*w

--------------------------------------------------------------------------
--	Enumerating seasons.						--
--------------------------------------------------------------------------

warmSeasons :: [Season]

warmSeasons = [Spring .. Autumn]
