--------------------------------------------------------------------------
--                                                                      --
--	Section 13.1: Lazy Evaluation 					--
--                                                                      --
--	(c) Simon Thompson, 1995.					--
--                                                                      --
--------------------------------------------------------------------------

-------------------------------------------------------------------------- 
--	Some simple examples.						--
-------------------------------------------------------------------------- 

egFun1 :: Int -> Int -> Int

egFun1 a b = a+b

exam1 = egFun1 (9-3) (egFun1 34 3)

egFun2 :: Int -> Int -> Int

egFun2 a b = a+12

exam2 = egFun2 (9-3) (egFun1 34 3)

-------------------------------------------------------------------------- 
-- 	A more realistic example.					--
-------------------------------------------------------------------------- 

switch :: Int -> t -> t -> t
switch n x y 
  | n>0 	= x
  | otherwise 	= y

-------------------------------------------------------------------------- 
--	An example in which work might be duplicated if evaluation is	--
--	not properly 'lazy'.						--
-------------------------------------------------------------------------- 

egFun3 :: Int -> Int -> Int

egFun3 a b = a+a

exam3 = egFun3 (9-3) (egFun1 34 3)

-------------------------------------------------------------------------- 
--	Lazy evaluation and structured arguments.			--
-------------------------------------------------------------------------- 

egFun4 :: (Int,Int) -> Int

egFun4 (a,b) = a+1

exam4 = egFun4 (3+2,4-17)

