--------------------------------------------------------------------------
--                                                                      --
--	Section 13.3: List comprehensions revisited			--
--                                                                      --
--	(c) Simon Thompson, 1995.					--
--                                                                      --
--------------------------------------------------------------------------

-------------------------------------------------------------------------- 
--	All possible pairs from two lists: first elements from the 	--
--	first list; second from the second.				--
-------------------------------------------------------------------------- 

pairs :: [t] -> [u] -> [(t,u)]

pairs l m = [ (a,b) | a<-l , b<-m ]

exam1 :: [(Int,Int)]

exam1 = pairs [1,2,3] [4,5] 

-------------------------------------------------------------------------- 
--	Triangular pairs.						--
-------------------------------------------------------------------------- 

triangle :: Int -> [(Int,Int)]

triangle n = [ (a,b) | a <- [1 .. n] , b <- [1 .. a] ]

exam2 = triangle 3 

-------------------------------------------------------------------------- 
--	Pythagorean triples: (a,b,c) such that a*a + b*b = c*c 		--
-------------------------------------------------------------------------- 

pyTriple n
  = [ (a,b,c) | a <- [2 .. n] , b <- [a+1 .. n] , c <- [b+1 .. n] , 
		a*a + b*b == c*c ]

exam3 :: [(Int,Int,Int)]

exam3 = pyTriple 100 

-------------------------------------------------------------------------- 
--	Examples on calculation.					--
-------------------------------------------------------------------------- 

isEven :: Int -> Bool

isEven n = (n `mod` 2 == 0)

exam4 = [ a+b | a <- [1,2] , isEven a , b <- [a .. 2*a] ]

exam5 :: [(Int,Int)]

exam5 = [ (a,b) | a <- [1 .. 3] , b <- [1 .. a] ]

exam6 :: [Int]

exam6 = [ m*m | m <- [1 .. 10] , m*m<50 ]

-------------------------------------------------------------------------- 
--	Example: list permutations					--
--									--
--	In Haskell 1.3 the function to remove an element from a list	--
--	given in 1.2 by \\[a] needs to be defined from scratch 		--
--	(exercise for the reader).					--
-------------------------------------------------------------------------- 

perms :: Eq t => [t] -> [[t]]

perms [] = [[]]
perms x  = [ a:p | a <- x , p <- perms (x\\[a]) ]

exam7,exam8,exam9 :: [[Int]]
exam7 = perms [2]
exam8 = perms [2,3]
exam9 = perms [1,2,3]

perm :: [t] -> [[t]]

perm []    = [[]]
perm (a:x) = [ p++[a]++q | r <- perm x ,
                           (p,q) <- splits r ]

-------------------------------------------------------------------------- 
--	All possible splits of a list.					--
-------------------------------------------------------------------------- 

splits :: [t]->[([t],[t])]

splits []    = [([],[])]
splits (a:x) = ([],a:x) : [ (a:p,q) | (p,q) <- splits x]

-------------------------------------------------------------------------- 
--	Vectors and Matrices						--
-------------------------------------------------------------------------- 

type Vector = [Float]

-------------------------------------------------------------------------- 
--	Scalar product of two vectors.					--
-------------------------------------------------------------------------- 

scalarProduct :: Vector -> Vector -> Float

scalarProduct l m = sum [ a*b | (a,b) <- zip l m ]


-------------------------------------------------------------------------- 
--	A matrix is a list of rows.					--
-------------------------------------------------------------------------- 

type Matrix = [Vector]

-------------------------------------------------------------------------- 
--	Product of matrices.						--
-------------------------------------------------------------------------- 

matrixProduct :: Matrix -> Matrix -> Matrix

matrixProduct m p
  = [ [scalarProduct r c | c <- columns p] | r <- m ]

-------------------------------------------------------------------------- 
--	Convert the list of rows to a list of columns.			--
-------------------------------------------------------------------------- 

columns :: Matrix -> Matrix

columns y = [ [ z!!j | z <- y ] | j<- [0 .. s] ]
            where 
            s = length (head y)-1

-------------------------------------------------------------------------- 
--	From the exercises....						--
-------------------------------------------------------------------------- 

exam10 :: [Int]

exam10 = [ a+b | a <- [1 .. 4] , b <- [2 .. 4] , a>b ]

-- subLists,subSequences :: [t] -> [[t]]

exam11 = matrixProduct [[2.0,3.0,4.0],[5.0,6.0,-1.0]]
		       [[1.0,0.0],[1.0,1.0],[0.0,-1.0]]


