--------------------------------------------------------------------------
--                                                                      --
--	Section 13.4: Data on demand					--
--                                                                      --
--	(c) Simon Thompson, 1995.					--
--                                                                      --
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--                                                                      --
--	In Gofer only load after					--
--		../Chapter12/Section12-9.g				--
--		../Chapter12/Section12-10.g				--
--                                                                      --
--	 In Hugs only load after       					--
--	        ../Chapter12/Section12-9.hugs  				--
--	        ../Chapter12/Section12-10.hugs				--
--                                                                      --
--------------------------------------------------------------------------

-------------------------------------------------------------------------- 
--	Summing fourth powers in a data-directed way.			--
-------------------------------------------------------------------------- 

sumFourthPowers n = sum (map (^4) [1 .. n])

-------------------------------------------------------------------------- 
--	Running graph example.						--
-------------------------------------------------------------------------- 

graphEx :: Relation Int

graphEx = makeSet [(1,2),(1,3),(2,4),(3,5),(5,6),(3,6)]

-------------------------------------------------------------------------- 
--	Routes from one point to another in a relation (graph).		--
-------------------------------------------------------------------------- 

routes :: Ord t => Relation t -> t -> t -> [[t]]

routes rel a b
  | a==b 	= [[a]]
  | otherwise	= [ a:r | c <- nbhrs rel a , r <- routes rel c b ]

-------------------------------------------------------------------------- 
--	The listof neighbours of a point in a relation.			--
-------------------------------------------------------------------------- 

nbhrs :: Ord t => Relation t -> t -> [t]

nbhrs rel a = flatten (image rel a)

exam1 = routes graphEx 1 4
exam2 = routes graphEx 1 6 

-------------------------------------------------------------------------- 
--	Routes through a potentially cyclic graph.			--
-------------------------------------------------------------------------- 

routesC :: Ord t => Relation t -> t -> t -> [t] -> [[t]]

routesC rel a b l
  | a==b 	= [[a]]
  | otherwise	= [ a:r | c <- nbhrs rel a \\ l , r <- routesC rel c b (a:l) ]

-------------------------------------------------------------------------- 
--	From the exercises.						--
-------------------------------------------------------------------------- 

graphEx2 :: Relation Int

graphEx2 = makeSet [(1,2),(2,1),(1,3),(2,4),(3,5),(5,6),(3,6)]


