--------------------------------------------------------------------------
--                                                                      --
--	Section 2.10: Data structures: Tuples				--
--                                                                      --
--	(c) Simon Thompson, 1995.					--
--                                                                      --
--------------------------------------------------------------------------

-------------------------------------------------------------------------- 
--	A type of people.						--
-------------------------------------------------------------------------- 

type Person = (String,String,Int)

-------------------------------------------------------------------------- 
--	Example tuples							--
-------------------------------------------------------------------------- 

joe :: Person
joe = ("Joe Grundy","0000-000000",73)

mary :: Person
mary =  ("Mary Poppins","0800-000-000",68)

intP :: (Int,Int)
intP =  (34,32)

-------------------------------------------------------------------------- 
--	Specifying the type of a function minNmax.			--
-------------------------------------------------------------------------- 

minNmax :: Int -> Int -> Int -> (Int,Int)

minNmax = minNmax	-- dummy definition
			-- needs redefinition

-------------------------------------------------------------------------- 
--	Pattern matching: adding a pair of numbers.			--
-------------------------------------------------------------------------- 

addPair :: (Int,Int) -> Int

addPair (x,y) = x+y

-------------------------------------------------------------------------- 
--	Shifting numbers around.					--
-------------------------------------------------------------------------- 

shift :: ((Int,Int),Int) -> (Int,(Int,Int))

shift ((a,b),c) = (a,(b,c))

-------------------------------------------------------------------------- 
--	Selecting components of a tuple using functions.		--
-------------------------------------------------------------------------- 

name  :: Person -> String
phone :: Person -> String
age   :: Person -> Int

name  (n,p,a) = n
phone (n,p,a) = p
age   (n,p,a) = a

-------------------------------------------------------------------------- 
--	Built-in functions on pairs.					--
--		fst (x,y) = x						--
--		snd (x,y) = y						--
-------------------------------------------------------------------------- 

-------------------------------------------------------------------------- 
--	Adding two numbers.						--
-------------------------------------------------------------------------- 

addTwo :: Int -> Int -> Int

addTwo a b = a+b
