--------------------------------------------------------------------------
--                                                                      --
--	Section 4.3: Designing functions over lists			--
--                                                                      --
--	(c) Simon Thompson, 1995.					--
--                                                                      --
--------------------------------------------------------------------------

-------------------------------------------------------------------------- 
--	Sorting a list of numbers.					--
-------------------------------------------------------------------------- 

iSort :: [Int] -> [Int]

iSort []    = [] 
iSort (a:x) = ins a (iSort x) 

-------------------------------------------------------------------------- 
--	Inserting an element in the proper place.			--
-------------------------------------------------------------------------- 

ins :: Int -> [Int] -> [Int]

ins a []    = [a] 
ins a (b:y) 
  | a <= b  	= a:(b:y)
  | otherwise 	= b : ins a y

-------------------------------------------------------------------------- 
--	 Is a number a member of a list?				--
-------------------------------------------------------------------------- 

member :: [Int] -> Int -> Bool

member []    b = False
member (a:x) b = (a==b) || member x b

-------------------------------------------------------------------------- 
--	alternative definition of member.				--
-------------------------------------------------------------------------- 

mem :: [Int] -> Int -> Bool

mem []    b = False
mem (a:x) b 
  | a==b 	= True
  | otherwise 	= mem x b

-------------------------------------------------------------------------- 
--	Getting the digits in a string.					--
-------------------------------------------------------------------------- 

digits :: String -> String

digits [] = []
digits (first:rest) 
  | isDigit first 	= first : digits rest
  | otherwise 		= digits rest

--------------------------------------------------------------------------
--	To work with Hugs0 the definition of				--
--		isDigit :: Char -> Bool					--
--		isDigit ch = '0' <= ch && ch <= '9'			--
--	needs to be added.						--
--------------------------------------------------------------------------

