--------------------------------------------------------------------------
--                                                                      --
--	Chapter 5: Reasoning about lists				--
--                                                                      --
--	(c) Simon Thompson, 1995.					--
--                                                                      --
--------------------------------------------------------------------------

-------------------------------------------------------------------------- 
--	Summing a list; doubling every element.				--
-------------------------------------------------------------------------- 

sumList :: [Int] -> Int

sumList []    = 0  
sumList (b:y) = b + sumList y 

double :: [Int] -> [Int]

double []    = []  
double (b:y) = (2*b) : double y  


-------------------------------------------------------------------------- 
--	Append -- pre-defined in Haskell.				--
--									--
--	[]    ++ v = v 							--
--	(c:u) ++ v = c:(u++v) 						--
-------------------------------------------------------------------------- 

-------------------------------------------------------------------------- 
--	Membership of a list						--
-------------------------------------------------------------------------- 

member :: String -> Char -> Bool

member []    d = False
member (c:z) d = (c==d) || member z d

-------------------------------------------------------------------------- 
--	To flatten a list of lists -- concat is built-in.		--
--									--
--	concat :: [[Int]] -> [Int]					--
--									--
--	concat []    = []						--
--	concat (c:z) = c ++ concat z					--
-------------------------------------------------------------------------- 

-------------------------------------------------------------------------- 
--	Is a list of numbers sorted?					--
-------------------------------------------------------------------------- 

sorted :: [Int] -> Bool

sorted []      = True
sorted [a]     = True
sorted (a:b:x) = (a<=b) && sorted (b:x)

-------------------------------------------------------------------------- 
--	Shunting from one list to another.				--
-------------------------------------------------------------------------- 

shunt :: [Int] -> [Int] -> [Int]

shunt []    y = y 
shunt (a:x) y = shunt x (a:y) 

exam1 = shunt [2,3,1] []

-------------------------------------------------------------------------- 
--	Reversing a list by shunting.					--
-------------------------------------------------------------------------- 

rev :: [Int] -> [Int]

rev l = shunt l []


-------------------------------------------------------------------------- 
--	Another reversing function.					--
-------------------------------------------------------------------------- 

rev2 ::  [Int] -> [Int]

rev2 []    = []
rev2 (a:x) = rev2 x ++ [a]

-------------------------------------------------------------------------- 
--	Auxiliary function used in a different version of the factorial	--
--	function.							--
-------------------------------------------------------------------------- 

facAux :: Int -> Int -> Int

facAux 0 p = p
facAux n p = facAux (n-1) (n*p)

-------------------------------------------------------------------------- 
--	A different factorial.						--
-------------------------------------------------------------------------- 

fac2 :: Int -> Int

fac2 n = facAux n 1

