--------------------------------------------------------------------------
--                                                                      --
--	Section 7.3: Partial Application.				--
--                                                                      --
--	(c) Simon Thompson, 1995.					--
--                                                                      --
--------------------------------------------------------------------------

infixr 9 >.>

f >.> g = g . f

-------------------------------------------------------------------------- 
--	Multiply two numbers.						--
-------------------------------------------------------------------------- 

multiply :: Int -> Int -> Int

multiply a b = a*b

-------------------------------------------------------------------------- 
--	Double every element of a list.					--
-------------------------------------------------------------------------- 

doubleList :: [Int] -> [Int]

doubleList = map (multiply 2)

-------------------------------------------------------------------------- 
--	Examples -- find their type by typing exam1:: etc.		--
-------------------------------------------------------------------------- 

exam1 = multiply 2       
exam2 = multiply 2 3     
exam3 = doubleList       
exam4 = doubleList [2,3] 

--------------------------------------------------------------------------
--	Member is elem with argument order swapped.			--
--------------------------------------------------------------------------

member :: String -> Char -> Bool

member st x = elem x st


-------------------------------------------------------------------------- 
--	Further examples						--
-------------------------------------------------------------------------- 

exam5 :: String -> String

exam5 = filter (not . member whitespace)

-------------------------------------------------------------------------- 
--	A function of type (Int -> Int) -> Int.				--
-------------------------------------------------------------------------- 

g :: (Int -> Int) -> Int

g h = (h 0) + (h 1)

-------------------------------------------------------------------------- 
--	Text processing revisited.					--
-------------------------------------------------------------------------- 

whitespace = "\n\t "

dropSpace = dropWhile (member whitespace)
dropWord  = dropWhile (( not ).member whitespace)
getWord   = takeWhile (( not ).member whitespace)

-------------------------------------------------------------------------- 
--	Using operator sections.					--
-------------------------------------------------------------------------- 

exam6 :: [Int] -> [Int]

exam6 = map (+1) >.> filter (0<) 

