--------------------------------------------------------------------------
--                                                                      --
--	Section 7.4: Examples.						--
--                                                                      --
--	(c) Simon Thompson, 1995.					--
--                                                                      --
--------------------------------------------------------------------------

-------------------------------------------------------------------------- 
--	Double every element of a list.					--
-------------------------------------------------------------------------- 

double :: [Int] -> [Int]

double = map (*2)

-------------------------------------------------------------------------- 
--	Get the even numbers in a list.					--
-------------------------------------------------------------------------- 

getEvens :: [Int] -> [Int]

getEvens = filter ((==0).(`mod` 2))

-------------------------------------------------------------------------- 
--	Books revisited.						--
-------------------------------------------------------------------------- 

books db per = map snd (filter ((==per).fst) db)

-------------------------------------------------------------------------- 
--	A simplification of the definition of getWord			--
-------------------------------------------------------------------------- 

getWord :: String -> String

getWord = getUntil (`elem` whitespace)

whitespace :: String

whitespace = "\n\t "

getUntil :: (t -> Bool) -> [t] -> [t]

getUntil p []	 = []
getUntil p (a:x)
  | (p a)		= []
  | otherwise		= a : getUntil p x

