--------------------------------------------------------------------------
--                                                                      --
--	Section 7.5: Currying and uncurrying				--
--                                                                      --
--	(c) Simon Thompson, 1995.					--
--                                                                      --
--------------------------------------------------------------------------

-------------------------------------------------------------------------- 
--	An 'uncurried' version of multiplication.			--
-------------------------------------------------------------------------- 

multiplyUC :: (Int,Int) -> Int

multiplyUC (a,b) = a*b

-------------------------------------------------------------------------- 
--	Go from uncurried to curried.					--
-------------------------------------------------------------------------- 

-- curry :: ((t,u) -> v) -> (t -> u -> v)

-- curry g a b = g (a,b)

-------------------------------------------------------------------------- 
--      Go from curried to uncurried.                                   --
-------------------------------------------------------------------------- 

-- uncurry :: (t -> u -> v) -> ((t,u) -> v)

-- uncurry f (a,b) = f a b

-------------------------------------------------------------------------- 
--	Swap the order of arguments to a curried function.		--
-------------------------------------------------------------------------- 

flip' :: (t -> u -> v) -> (u -> t -> v)

flip' f b a = f a b

