--------------------------------------------------------------------------
--                                                                      --
--	Section 8.1: Introducing classes 				--
--                                                                      --
--	(c) Simon Thompson, 1995.					--
--                                                                      --
--------------------------------------------------------------------------



--------------------------------------------------------------------------
--	Forward composition is used in this file.			--
--------------------------------------------------------------------------

infixl 9 >.>
f >.> g = g.f

-------------------------------------------------------------------------- 
--	Are three values equal?						--
-------------------------------------------------------------------------- 

allEqual :: Eq t => t -> t -> t -> Bool
allEqual n m p = (n==m) && (m==p)

--------------------------------------------------------------------------
--	Books renamed...						--
--------------------------------------------------------------------------

lookupFirst :: Eq t => [(t,u)] -> t -> [u]

lookupFirst [] a = []
lookupFirst ((b,c):rest) a
  | b==a	= c : lookupFirst rest a
  | otherwise	=     lookupFirst rest a

--------------------------------------------------------------------------
--	List membership							--
--------------------------------------------------------------------------

member :: Eq t => [t] -> t -> Bool

member []    b = False
member (a:x) b = (a==b) || member x b

