||----------------------------------------------------------------------||
||									||
||	calc.m								||
||									||
||	A simple-minded calculator.					||
||									||
||	May 1994							||
||									||
||----------------------------------------------------------------------||

%include "express2"

||----------------------------------------------------------------------||
||	commands -- turn an input stream into a list of commands.	||
||----------------------------------------------------------------------||

commands :: [char] -> [command]

commands = map success . map command_parse . lines

||----------------------------------------------------------------------||
||	Pick the successful parse from a list of partial parses. If no	||
||	such, return the Null command.					||
||----------------------------------------------------------------------||

success :: [(command,[char])] -> command

success ((c,[]):rest) = c
success (a:rest) = success rest
success [] = Null

||----------------------------------------------------------------------||
||	Evaluate an expression.						||
||----------------------------------------------------------------------||

eval :: expr -> store -> num

eval (Lit n) st = n
eval (Var v) st = lookup st v
eval (Op op e1 e2) st
	= opValue op v1 v2
	  where
	  v1 = eval e1 st
	  v2 = eval e2 st

||----------------------------------------------------------------------||
||	The value of an operator					||
||----------------------------------------------------------------------||

opValue ::  op -> num -> num -> num

opValue Add = (+)
opValue Sub = (-)
opValue Mult = (*)
opValue Div = (div)
opValue Mod = (mod)

||----------------------------------------------------------------------||
||	Stores as an ADT						||
||	0 taken as default lookup value.				||
||----------------------------------------------------------------------||

abstype store with

  initial :: store
  lookup :: store -> var -> num
  update :: store -> var -> num -> store

store == [ (num,var) ]

initial = []

lookup [] v = 0
lookup ((n,w):st) v = n			, if v=w
		    = lookup st v	, otherwise

update st v n = (n,v):st

||----------------------------------------------------------------------||
||	Top level							||
||----------------------------------------------------------------------||

calculate :: [command] -> store -> [char]

calculate ((Eval e):cs) st 
	= show (eval e st) ++"\n" ++ calculate cs st

calculate ((Assign v e):cs) st
	= [v] ++ " := " ++ show val ++ "\n" ++ calculate cs st'
	  where
	  val = eval e st
	  st' = update st v val

calculate (Null:cs) st
	= "Null command\n" ++ calculate cs st

calculate [] st = []

||----------------------------------------------------------------------||
||	Perform!							||
||----------------------------------------------------------------------||

perform = calculate (commands (read "/dev/tty")) initial
