||----------------------------------------------------------------------|| 
||									||
||	express2.m							||
||									||
||	The type of integer expressions					||
||	and a parser for it.						||
||	Improved to include precedences and right associativity.	||
||									||
||	May 1994							||
||									||
||----------------------------------------------------------------------|| 

%include "parse.m"

||----------------------------------------------------------------------|| 
||	First we define the syntax of the numerical expressions.	||
||									||
||	The concrete syntax is as follows:				||
||		Literals :	67,023,~89,~123 etc.			||
||		Variables :	a,b,c,...,z				||
||		Binary ops : 	+,*,-,/,% (last is for mod)		||
||									||
||	expr ::= num | var | (expr op expr) |				||
||		 lexpr mop mexpr | mexpr aop expr			||
||									||
||	lexpr ::= num | var | (expr op expr)				||
||									||
||	mexpr ::= num | var | (expr op expr) |				||
||		  lexpr mop mexpr					||
||									||
||	mop ::= * | / | %						||
||	aop ::= + | -							||
||									||
||	White space not permitted.					||
||									||
||----------------------------------------------------------------------|| 

var == char

op ::= Add | Sub | Mult | Div | Mod

expr ::= Lit num |
	 Var var |
	 Op op expr expr

||----------------------------------------------------------------------||
||	Then we define various auxilliary functions which recognise	||
||	various components of the concrete representations of the 	||
||	expressions.							||
||----------------------------------------------------------------------|| 

is_var :: char -> bool

is_var ch = ('a' <= ch <= 'z')

is_op,is_mop,is_aop  :: char -> bool

is_op = member [ '+' , '-' , '*' , '/' , '%' ]
is_mop = member [ '*' , '/' , '%' ]
is_aop = member [ '+' , '-' ]

is_digit :: char -> bool

is_digit ch = ('0' <= ch <= '9')

lb :: char

lb = '('

rb :: char

rb = ')'

||----------------------------------------------------------------------|| 
||	We now introduce some routines for conversion between 		||
||	concrete representations of numbers and operators and 		||
||	their abstract counterparts.					||
||									||
||	charlist_to_expr takes a list of characters representing 	||
||	an integer, and returns (Lit n) where n is the value of the	||
||	string. The function uses..					||
||									||
||	diglist_to_num which converts a list of digits into a		||
||	(positive) integer.						||
||									||
||	char_to_op does the obvious thing.				||
||----------------------------------------------------------------------|| 

charlist_to_expr :: [char] -> expr

charlist_to_expr l
	= Lit ( (sign_l) * diglist_to_num (numpart_l) )
	  where
	  (sign_l,numpart_l) = (1,[])	  , if  l=[]
			     = (1,l)	  , if  hd l ~= '~'
			     = (-1,tl l)  , otherwise


diglist_to_num :: [char] -> num

diglist_to_num 
     =  (foldl' add 0) . (map digit_to_num) 
	where
	digit_to_num ch = code ch - code '0'
	foldl' f st [] = st
	foldl' f st (a:x) = foldl' f (f st a) x
	add n d = n*10 + d

char_to_op :: char -> op

char_to_op '+' = Add
char_to_op '-' = Sub
char_to_op '*' = Mult
char_to_op '/' = Div
char_to_op '%' = Mod

||----------------------------------------------------------------------|| 
||	The parser itself. At the top level there are five		||
||	alternatives, which we'd expect from the form of the 		||
||	grammar.							||
||----------------------------------------------------------------------|| 

exprP :: parse char expr

exprP = lit_parse $alt var_parse $alt op_exp_parse $alt
	lexpr_mop_mexp_parse $alt mexpr_aop_exp_parse

||----------------------------------------------------------------------||
||	lexpr								||
||----------------------------------------------------------------------||

lexprP :: parse char expr

lexprP = lit_parse $alt var_parse $alt op_exp_parse

||----------------------------------------------------------------------||
||	mexpr								||
||----------------------------------------------------------------------||

mexprP :: parse char expr

mexprP = lit_parse $alt var_parse $alt op_exp_parse $alt
	 lexpr_mop_mexp_parse

||----------------------------------------------------------------------|| 
||	Lit_parse uses the optional constructor - it may or may not	||
||	recognise the token '~' (for unary minus). The result of this	||
||	is joined to the non-empty digit list following, and then 	||
||	conversion takes place.						||
||----------------------------------------------------------------------|| 

lit_parse = ( ( (optional (token '~')) $then
	    	(nelist (spot is_digit)) 
	      ) $do join 
	    ) $do charlist_to_expr
	     
		where
		join (l,m) = l++m

||----------------------------------------------------------------------|| 
||	Spot a variable, and then identify it as such, by tagging it	||
||	with Var.							||
||----------------------------------------------------------------------|| 

var_parse = spot is_var $do Var

||----------------------------------------------------------------------|| 
||	Recognise, sequentially, a left bracket, an expression, an	||
||	operator, another expression and finally a right bracket.	||
||	This results in a nested sequence of pairs, which is unpacked	||
||	and reassembled by make_expr.					||
||									||
||	( expr op expr )						||
||----------------------------------------------------------------------|| 

op_exp_parse 
      =	( token lb   $then
	  exprP     $then
	  spot is_op $then
	  exprP     $then
	  token rb ) $do
	  make_expr
	  where
	  make_expr (lb,(e1,(bop,(e2,rb)))) = Op (char_to_op bop) e1 e2

||----------------------------------------------------------------------||
||	lexpr mop mexpr							||
||----------------------------------------------------------------------||

lexpr_mop_mexp_parse 
      =	( lexprP     $then
	  spot is_mop $then
	  mexprP    ) $do
	  make_expr
	  where
	  make_expr (e1,(bop,e2)) = Op (char_to_op bop) e1 e2

||----------------------------------------------------------------------||
||	mexpr aop expr							||
||----------------------------------------------------------------------||

mexpr_aop_exp_parse 
      =	( mexprP     $then
	  spot is_aop $then
	  exprP    ) $do
	  make_expr
	  where
	  make_expr (e1,(bop,e2)) = Op (char_to_op bop) e1 e2

||----------------------------------------------------------------------|| 
||	Commands have a very simple syntax, taking one of two		||
||	forms. An							||
||		expr							||
||	is simply evaluated, and					||
||		var:expr						||
||	causes the variable to be updated to have the expression value.	||
||									||
||	May 94: the Null command is included as the effect of a syntax	||
||	error.								||
||----------------------------------------------------------------------|| 

command ::= Eval expr | Assign var expr | Null

||----------------------------------------------------------------------|| 
||	Parsing commands - uses the parser for expressions in a		||
||	simple-minded extension.					||
||----------------------------------------------------------------------|| 

command_parse :: parse char command

command_parse = (exprP $do Eval) $alt assign_parse

assign_parse
      = ( (spot is_var) $then
	  token ':'     $then 
	  exprP ) $do
	  make_assign
	  where
	  make_assign (v,(':',e)) = Assign v e
