||----------------------------------------------------------------------||
||                                                                      ||
||	parse.m								||
||									||
||	A library for parsing.						||
||	See Section 12.5 for a discussion of how this works.		||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	The type of parsers.						||
||----------------------------------------------------------------------|| 

parse * ** == [*] -> [(**,[*])]

||----------------------------------------------------------------------|| 
||	Some basic parsers						||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	Fail on any input.						||
||----------------------------------------------------------------------|| 

fail :: parse * **

fail in = []

||----------------------------------------------------------------------|| 
||	Succeed, returning the value supplied.				||
||----------------------------------------------------------------------|| 

succeed :: ** -> parse * ** 

succeed val in = [(val,in)]

||----------------------------------------------------------------------|| 
||	token t recognises t as the first value in the input.		||
||----------------------------------------------------------------------|| 

token :: * -> parse * *

token t (a:x) = [(t,x)]   , if t=a
              = []        , otherwise
token t []    = []

||----------------------------------------------------------------------|| 
||	spot whether an element with a particular property is the 	||
||	first element of input.						||
||----------------------------------------------------------------------|| 

spot :: (* -> bool) -> parse * *

spot p (a:x) = [(a,x)]    , if p a
             = []         , otherwise
spot p []    = []

||----------------------------------------------------------------------|| 
||	Combining parsers						||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	alt p1 p2 recognises anything recogniseed by p1 or by p2.	||
||----------------------------------------------------------------------|| 

alt :: parse * ** -> parse * ** -> parse * **

alt p1 p2 in = p1 in ++ p2 in

||----------------------------------------------------------------------|| 
||	Apply one parser then the second to the result(s) of the first.	||
||----------------------------------------------------------------------|| 

then :: parse * ** -> parse * *** -> parse * (**,***)
	
then p1 p2 in 
  = [((y,z),rem2) | (y,rem1) <- p1 in ; 
                    (z,rem2)  <- p2 rem1 ]

||----------------------------------------------------------------------|| 
||	Transform the results of the parses according to the function.	||
||----------------------------------------------------------------------|| 

do :: parse * ** -> (** -> ***) -> parse * ***

do p f in = [ (f x,rem) | (x,rem) <- p in ]

||----------------------------------------------------------------------|| 
||	Recognise a list of objects.					||
||----------------------------------------------------------------------|| 
	
list :: parse * ** -> parse * [**]

list p = (succeed []) $alt
         ((p $then list p) $do convert)
         where
         convert (a,x) = (a:x)

||----------------------------------------------------------------------|| 
||	Recognise a non-empty list of objects.				||
||----------------------------------------------------------------------|| 
	
nelist :: parse * ** -> parse * [**]

nelist p = (p $do sing) $alt
           ((p $then list p) $do convert)
           where
           convert (a,x) = (a:x)
	   sing a = [a]

||----------------------------------------------------------------------|| 
||	Optionally parse an object.					||
||----------------------------------------------------------------------|| 

optional :: parse * ** -> parse * [**]

optional p = (succeed []) $alt (p $do sing)
	     where
	     sing a = [a]
