||----------------------------------------------------------------------|| 
||									||
||	Chapter 1: Introducing functional programming			||
||									||
||	(c) Simon Thompson, 1995.					||
||									||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	The first example program.					||
||									||
||	((n - 3) * 2) + 6						||
||----------------------------------------------------------------------|| 


||----------------------------------------------------------------------|| 
||	Definitions from the example script.				||
||----------------------------------------------------------------------|| 

answer :: num               ||  A number constant 
answer = 42  

newline :: char 
newline = 'n'

yes :: bool                 ||  The answer yes is represented  
yes = True                  ||  by the Boolean value True.

greater :: bool             ||  Uses the value of answer
greater = (answer>71)

||----------------------------------------------------------------------|| 
||	Examples of function definitions.				||
||----------------------------------------------------------------------|| 

square :: num -> num
square x = x*x

allEqual :: num -> num -> num -> bool
allEqual n m p = (n=m) & (m=p)

maxi :: num -> num -> num
maxi n m 
  = n      , if n>=m
  = m      , otherwise

||----------------------------------------------------------------------|| 
||	Expressions to evaluate.					||
||									||
||	(2+3)								||
||	$$								||
||	5-4-3								||
||	7/3								||
||	7 div 3								||
||	4 div $$							||
||	7 mod 3								||
||	True \/ False							||
||	~ False & False							||
||									||
||	answer + 42							||
||	greater								||
||	square answer							||
||	square $$							||
||	allEqual 2 3 3							||
||	allEqual 5 5 5							||
||	allEqual (square 5) answer (maxi (-4) 2)			||
||									||
||	2+(3+4								||
||	2+(3+4))							||
||	True + 4							||
||	4 \& True							||
||	4 5								||
||	7 did 4								||
||	4 div (3*2-6)							||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	Type specifications.						||
||----------------------------------------------------------------------|| 

allFourEqual :: num -> num -> num -> num -> bool

howManyEqual :: num -> num -> num -> num

howManyOfTwoEqual :: num -> num -> num

cube :: num -> num
cube x = x * square x

