||----------------------------------------------------------------------||
||									||
||	codeTable.m							||
||									||
||	Converting a Huffman tree to a code table.			||
||									||
||	(c) Simon Thompson, 1995.					||
||									||
||----------------------------------------------------------------------||

%include "types.m"
%export codeTable

||----------------------------------------------------------------------||
||	Auxiliary function used in conversion to a table.		||
||----------------------------------------------------------------------||

convert :: hCode -> tree -> table

convert cd (Leaf c n) =  [(c,cd)]
convert cd (Node n t1 t2)
	= (convert (cd++[L]) t1) ++ (convert (cd++[R]) t2)

||----------------------------------------------------------------------||
||	Making a table from a Huffman tree				||
||----------------------------------------------------------------------||

codeTable = convert []

||----------------------------------------------------------------------||
||	Printing functions						||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------||
||	Show a tree, using indentation to show structure.		||
||									||
||	showTreeIndent has a second, current level of indentation,	||
||	parameter.							||
||----------------------------------------------------------------------||

showTree :: tree -> [char]

showTree t = showTreeIndent 0 t

showTreeIndent :: num -> tree -> [char]

showTreeIndent m (Leaf c n) 
	= spaces m ++ show c ++ " " ++ show n ++ "\n"
showTreeIndent m (Node n t1 t2)
	= showTreeIndent (m+4) t1 ++
	  spaces m ++ "[" ++ show n ++ "]" ++ "\n" ++
	  showTreeIndent (m+4) t2

||----------------------------------------------------------------------||
||	Printable version of code. 					||
||----------------------------------------------------------------------||

showCode :: hCode -> [char]
showCode = map conv
	   where
	   conv R = 'R'
	   conv L = 'L'

||----------------------------------------------------------------------||
||	Print a code table.						||
||----------------------------------------------------------------------||

showTable = concat . map showPair
		where
		showPair (c,n) = [c] ++ " " ++ showCode n ++ "\n"
