||----------------------------------------------------------------------||
||									||
||	coding.m							||
||									||
||	Huffman coding in Miranda.					||
||	The top-level functions for coding and decoding.		||
||									||
||	(c) Simon Thompson, 1995.					||
||									||
||----------------------------------------------------------------------||

%include "types.m"
%include "makeCode.m"		||	codes codeTable

||----------------------------------------------------------------------||
||	Code a message according to a table of codes.			||
||----------------------------------------------------------------------||

codeMessage :: table -> [char] -> hCode

codeMessage tbl = concat . map (lookupTable tbl)

||----------------------------------------------------------------------||
||	lookupTable looks up an individual char.			||
||----------------------------------------------------------------------||

lookupTable :: table -> char -> hCode

lookupTable [] c = error "lookupTable"
lookupTable ((ch,n):tb) c
	= n			, if ch=c
	= lookupTable tb c	, otherwise

||----------------------------------------------------------------------||
||	Decode a message according to a tree.				||
||									||
||	The first tree arguent is constant, being the tree of codes;	||
||	the second represents the current position in the tree relative	||
||	to the (partial) code read so far.				|| 
||----------------------------------------------------------------------||

decodeMessage :: tree -> hCode -> [char]

decodeMessage t
  = decodeByt t
    where

    decodeByt (Node n t1 t2) (L:rest)
	= decodeByt t1 rest

    decodeByt (Node n t1 t2) (R:rest)
	= decodeByt t2 rest

    decodeByt (Leaf c n) l
	= c : decodeByt t l

    decodeByt t1 [] = []

||----------------------------------------------------------------------||
||	Examples							||
||----------------------------------------------------------------------||

table1 = codeTable (codes (read "text1"))
table2 = codeTable (codes "there is a green hill")
tree1 = codes (read "text1")
message = "t is a full binary tree"
coded = codeMessage table1 message
decoded = decodeMessage tree1 coded
