||----------------------------------------------------------------------||
||									||
||	frequency.m							||
||									||
||	Calculating the frequencies of words in a text, used in 	||
||	Huffman coding.							||
||									||
||	(c) Simon Thompson, 1995.					||
||									||
||----------------------------------------------------------------------||

%include "types.m"
%export frequency

||----------------------------------------------------------------------||
||	Calculate the frequencies of characters in a list.		||
||									||
||	This is done by sorting, then counting the number of		||
||	repetitions. The counting is made part of the merge 		||
||	operation in a merge sort.					||
||----------------------------------------------------------------------||

frequency :: [char] -> [ (char,num) ]

frequency
  = mergeSort freqMerge . mergeSort alphaMerge . map start
    where
    start ch = (ch,1)

||----------------------------------------------------------------------||
||	Merge sort parametrised on the merge operation. This is more	||
||	general than parametrising on the ordering operation, since	||
||	it permits amalgamation of elements with equal keys		||
||	for instance.							||
||----------------------------------------------------------------------||
 
mergeSort :: ([*]->[*]->[*]) -> [*] -> [*]

mergeSort merge x
    		= x					, if #x < 2
                = merge (mergeSort merge first)
                	(mergeSort merge second)	, otherwise
                  where
                  first = take half x
                  second = drop half x
                  half = (# x) div 2
||----------------------------------------------------------------------||
||	Order on first entry of pairs, with				||
||	accumulation of the numeric entries when equal first entry.	||
||----------------------------------------------------------------------||

alphaMerge x [] = x
alphaMerge [] y = y
alphaMerge ((a,n):x) ((b,m):y)
    	= (a,n+m) : alphaMerge x y		, if a=b
    	= (a,n) : alphaMerge x ((b,m):y)	, if a<b
    	= (b,m) : alphaMerge ((a,n):x) y	, otherwise

||----------------------------------------------------------------------||
||	Lexicographic ordering, second field more significant.		||
||----------------------------------------------------------------------||

freqMerge x [] = x
freqMerge [] y = y
freqMerge ((a,n):x) ((b,m):y)
    	= (a,n) : freqMerge x ((b,m):y)	, if n<m \/ (n=m & a<b)
    	= (b,m) : freqMerge ((a,n):x) y	, otherwise
