||----------------------------------------------------------------------||
||									||
||	makeTree.m							||
||									||
||	Turn a frequency table into a Huffman tree			||
||									||
||	(c) Simon Thompson, 1995.					||
||									||
||----------------------------------------------------------------------||

%include "types.m"
%export toTreeList makeCodes

||----------------------------------------------------------------------||
||	Huffman codes are created bottom up: look for the least		||
||	two frequent letters, make these a new "letter" (i.e. tree)	||
||	and repeat until one tree formed.				||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------||
||	To tree list -- makes the initial data structure.		||
||----------------------------------------------------------------------||

toTreeList :: [ (char,num) ] -> [ tree ]

toTreeList = map toLeaf
	     where
	     toLeaf (c,n) = Leaf c n

||----------------------------------------------------------------------||
||	The value of a tree.						||
||----------------------------------------------------------------------||

value :: tree -> num

value (Leaf c n) = n
value (Node n t1 t2) = n

||----------------------------------------------------------------------||
||	Pair two trees.							||
||----------------------------------------------------------------------||

pair :: tree -> tree -> tree

pair t1 t2 = Node (v1+v2) t1 t2
	     where
	     v1 = value t1
	     v2 = value t2

||----------------------------------------------------------------------||
||	Insert a tree in a list of trees sorted by ascending value.	||
||----------------------------------------------------------------------||

insert :: tree -> [tree] -> [tree]

insert t [] = [t]
insert t (t1:ts) = t:t1:ts		, if value t <= value t1
		 = t1 : insert t ts	, otherwise
	
||----------------------------------------------------------------------||
||	Amalgamate the front two elements of the list of trees.		||
||----------------------------------------------------------------------||

amalgamate :: [ tree ] -> [ tree ]

amalgamate ( t1 : t2 : ts )
	= insert (pair t1 t2) ts

||----------------------------------------------------------------------||
||	Make codes: amalgamate the whole list.				||
||----------------------------------------------------------------------||

makeCodes :: [tree] -> tree

makeCodes [t] = t
makeCodes ts = makeCodes (amalgamate ts) 

