||----------------------------------------------------------------------||
||                                                                      ||
||	Section 11.3: Queues.						||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	The abstype header for queues.					||
||----------------------------------------------------------------------|| 

abstype 
  queue *
with
  emptyQ :: queue *
  addQ   :: * -> queue * -> queue *
  remQ   :: queue * -> (  * , queue * )

||----------------------------------------------------------------------|| 
||	Queues as lists: enqueued items at the end.			||
||----------------------------------------------------------------------|| 

queue * == [*]

emptyQ   = []
addQ a x = x++[a]
remQ x   = (hd x , tl x)        , if x~=[]
         = error "remQ"         , otherwise
