||----------------------------------------------------------------------||
||                                                                      ||
||	Section 11.3: Queues.						||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	The abstype header for queues.					||
||----------------------------------------------------------------------|| 

abstype 
  queue *
with
  emptyQ :: queue *
  addQ   :: * -> queue * -> queue *
  remQ   :: queue * -> (  * , queue * )

||----------------------------------------------------------------------|| 
||	A two-list implementation of queues.				||
||----------------------------------------------------------------------|| 

queue * == ([*],[*])

emptyQ       = ([],[])
addQ a (l,r) = (l,a:r)
remQ (a:l,r) = (a,(l,r))
remQ ([] ,r) = remQ (reverse r,[])   , if r~=[]
             = error "remQ"          , otherwise


