||----------------------------------------------------------------------||
||                                                                      ||
||	Section 11.5: Simulation.					||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

%include "../Simulation/types.m"

||----------------------------------------------------------------------|| 
||	The signature for queues as an abstract data type in the	||
||	simulation example.						||
||----------------------------------------------------------------------|| 

abstype
 queueState
with
 addMessage  :: inmess -> queueState -> queueState
 queueStep   :: queueState -> ( queueState , [outmess] )
 queueStart  :: queueState
 queueLength :: queueState -> num
 queueEmpty  :: queueState -> bool

||----------------------------------------------------------------------|| 
||	The signature for the server.					||
||----------------------------------------------------------------------|| 

abstype
 serverState
with
 addToQueue     :: num -> inmess -> serverState -> serverState
 serverStep     :: serverState -> ( serverState , [outmess] )
 simulationStep :: serverState -> inmess -> ( serverState , [outmess] ) 
 serverStart    :: serverState
 serverSize     :: serverState -> num
 shortestQueue  :: serverState -> num

||----------------------------------------------------------------------|| 
||	Implementing the simulation					||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	The queue							||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	The queueState type implementation.				||
||----------------------------------------------------------------------|| 

queueState == (time,service,[inmess])

||	addMessage  :: inmess -> queueState -> queueState

addMessage im (time,serv,ml) = (time,serv,ml++[im])

||	queueStep   :: queueState -> ( queueState , [outmess] )

queueStep (time , servSoFar , Yes a serv : inRest)
  = ((time+1, servSoFar+1 , Yes a serv : inRest) , [])
                   , if servSoFar < serv
  = ((time+1, 0 , inRest) , [Discharge a (time-serv-a) serv])
                   , otherwise

queueStep (time,serv,[]) = ((time+1,serv,[]) , [])

||	queueStart  :: queueState

queueStart  =  (0,0,[])

||	queueLength :: queueState -> num

queueLength (time,serv,l) = #l

||	queueEmpty  :: queueState -> bool

queueEmpty (t,s,q)  = (q=[])

||----------------------------------------------------------------------|| 
||	Implementing the server						||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	The carrier type for the server.				||
||----------------------------------------------------------------------|| 

serverState == [queueState]

||	addToQueue :: num -> inmess -> serverState -> serverState

addToQueue n im st
  = take n st ++ [newQueueState] ++ drop (n+1) st
    where
    newQueueState = addMessage im (st!n)

||	serverStep :: serverState -> ( serverState , [outmess] )

serverStep [] = ([],[])
serverStep (q:qs) 
  = (q':qs' , mess++messes)
    where
    (q' , mess)    = queueStep  q
    (qs' , messes) = serverStep qs

||	simulationStep :: serverState -> inmess -> ( serverState , [outmess] )

simulationStep servSt im 
  = (addNewObject im servSt1 , outmess)
    where
    (servSt1 , outmess) = serverStep servSt

||	addNewObject :: inmess -> serverState -> serverState

addNewObject No servSt = servSt

addNewObject (Yes arr wait) servSt
  = addToQueue (shortestQueue servSt) (Yes arr wait) servSt
 
||	serverStart :: serverState

serverStart = rep numQueues queueStart 

||	serverSize :: serverState -> num

serverSize = (#)

||	shortestQueue :: serverState -> num

shortestQueue [q] = 0
shortestQueue (q:qs) 
  = short+1   , if queueLength (qs!short) <= queueLength q
  = 0         , otherwise
    where
    short = shortestQueue qs

||----------------------------------------------------------------------|| 
||	numQueues is a constant to be defined.				||
||----------------------------------------------------------------------|| 

numQueues :: num
 
numQueues = 4

||----------------------------------------------------------------------|| 
||	Examples							||
||----------------------------------------------------------------------|| 

||	exam1 = queueStep (12,3,[Yes 8 4])
||	exam2 = queueStep (13,4,[Yes 8 4])
||	exam3 = queueStep (14,0,[])

||	serverSt1 = [ (13,4,[Yes 8 4]) , (13,3,[Yes 8 4]) ]

||	exam4 = serverStep serverSt1
||	exam5 = simulationStep (Yes 13 10) serverSt1


