||----------------------------------------------------------------------||
||                                                                      ||
||	Section 11.7: Search Trees					||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

%include "errorType.m"

||----------------------------------------------------------------------|| 
||	The implementation type -- hence the 'i'.			||
||----------------------------------------------------------------------|| 

itree * ::= Nil | Node * (itree *) (itree *)

||----------------------------------------------------------------------|| 
||	The abstype							||
||----------------------------------------------------------------------|| 

abstype 
  tree *
with
  nil      :: tree *
  isNil    :: tree * -> bool
  isNode   :: tree * -> bool
  leftSub  :: tree * -> tree *
  rightSub :: tree * -> tree *
  treeVal  :: tree * -> *
  insert   :: * -> tree * -> tree *
  delete   :: * -> tree * -> tree *
  join     :: tree * -> tree * -> tree *
  minTree  :: tree * -> err *

||----------------------------------------------------------------------|| 
||	Implementing the abstype					||
||----------------------------------------------------------------------|| 

tree * == itree *

||	nil :: tree *

nil = Nil

||	isNil , isNode :: tree * -> bool

isNil  = (=Nil)
isNode = (~=Nil)

||	leftSub , rightSub :: tree * -> tree *

leftSub Nil            = error "leftSub"
leftSub (Node v t1 t2) = t1

rightSub Nil            = error "rightSub"
rightSub (Node v t1 t2) = t2

||	treeVal  :: tree * -> *

treeVal Nil            = error "treeVal"
treeVal (Node v t1 t2) = v

||	insert :: * -> tree * -> tree *

insert val Nil = (Node val Nil Nil)

insert val (Node v t1 t2)
  = Node v t1 t2                , if v=val
  = Node v t1 (insert val t2)	  , if val > v
  = Node v (insert val t1) t2	  , if val < v

||	delete :: * -> tree * -> tree *

delete val (Node v t1 t2)
  = Node v (delete val t1) t2   , if val < v
  = Node v t1 (delete val t2)   , if val > v
  = t1                          , if t2 = Nil
  = t2                          , if t1 = Nil
  = join t1 t2                  , otherwise

||	join :: tree * -> tree * -> tree *

join t1 t2 
  = Node mini t1 newt
    where
    (OK mini) = minTree t2
    newt      = delete mini t2

||	minTree :: tree * -> err *

minTree t
  = Error      , if isNil t
  = OK v       , if isNil t1 
  = minTree t1 , otherwise
    where
    t1 = leftSub t
    v  = treeVal t

||----------------------------------------------------------------------|| 
||	The size function -- definable using the operations of the	||
|| 	abstype.							||
||----------------------------------------------------------------------|| 

size :: tree * -> num
size t 
  = 0                                          , if isNil t
  = 1 + size (leftSub t) + size (rightSub t)   , otherwise

||----------------------------------------------------------------------|| 
||	Finding the nth element of a tree.				||
||----------------------------------------------------------------------|| 

indexT :: num -> tree * -> *

indexT n t 
  = error "indexT"       , if isNil t
  = indexT n t1          , if n < st1
  = v                    , if n = st1
  = indexT (n-st1-1) t2  , otherwise
    where
    v   = treeVal t
    t1  = leftSub t
    t2  = rightSub t
    st1 = size t1

||----------------------------------------------------------------------|| 
||	The files 							||
||		sTree.m							||
||		sTreeAu.m						||
||		sTreeAb.m						||
||		sTreeAA.m						||
||	in this directory contain variants of the tree type. 		||
||									||
||	sTree.m		a concrete implementation of search trees: uses	||
||			pattern matching over the trees to define 	||
||			functions.					||
||	sTreeAu.m	how sTree.m has to be modified if a size field	||
||			is added to the concrete type: all pattern	||
||                      matches have to change.				||
||	sTreeAb.m	the implementation as here -- an abstype.	||
||	sTreeAA.m	the modified abstype implementation: none of	||
||			the functions defined using the abstype need	||
||			to be modified.					||
||----------------------------------------------------------------------|| 

