||----------------------------------------------------------------------||
||                                                                      ||
||	Section 11.8: Case Study: sets					||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	The abstype siognature for sets of objects of type *		||
||----------------------------------------------------------------------|| 

abstype
  set *
with            
  empty              :: set *
  sing               :: * -> set *
  memSet             :: set * -> * -> bool
  union,inter,diff   :: set * -> set * -> set *
  subSet,eqSet       :: set * -> set * -> bool
  makeSet            :: [*] -> set *
  mapSet             :: (* -> **) -> set * -> set **
  filterSet          :: (*->bool) -> set * -> set *
  foldSet            :: (* -> * -> *) -> * -> set * -> *
  showSet            :: (*->[char]) -> set * -> [char]
  card               :: set * -> num
  setLimit           :: (set * -> set *) -> set * -> set *

||----------------------------------------------------------------------|| 
||	The implementation.						||
||	Ordered lists without repetitions.				||
||----------------------------------------------------------------------|| 

set * == [*]

empty  = []

sing a = [a]

memSet [] b    = False
memSet (a:x) b = memSet x b     , if a<b
               = True           , if a=b
               = False          , otherwise

union [] y        = y
union x []        = x
union (a:x) (b:y) = a : union x (b:y)   , if a<b
                  = a : union x y       , if a=b
                  = b : union (a:x) y   , otherwise

inter [] y = []
inter x [] = []
inter (a:x) (b:y) = inter x (b:y)       , if a<b
                  = a : inter x y       , if a=b
                  = inter (a:x) y       , otherwise

diff [] y = []
diff x [] = x
diff (a:x) (b:y)  = a : diff x (b:y)    , if a<b
                  = diff x y            , if a=b
                  = diff (a:x) y        , otherwise

subSet [] y = True
subSet x [] = False
subSet (a:x) (b:y) = False              , if a<b
                   = subSet x y         , if a=b
                   = subSet (a:x) y     , if a>b

eqSet = (=)

makeSet = remDups . sort
          where
          remDups []     = []
          remDups [a]    = [a]
          remDups (a:b:x) = a : remDups (b:x) , if a < b
                        = remDups (b:x)       , otherwise

mapSet f  = makeSet . (map f)

filterSet = filter

foldSet   = foldr

showSet f = concat . (map ((++"\n") . f))

card      = (#)

setLimit f x = x                , if eqSet x next
             = setLimit f next  , otherwise
               where
               next = f x

||----------------------------------------------------------------------|| 
||	From the exercises....						||
||----------------------------------------------------------------------|| 

symmDiff :: set * -> set * -> set *

powerSet :: set * -> set (set *)

setUnion :: set (set *) -> set *
setInter :: set (set *) -> set *

