||----------------------------------------------------------------------||
||                                                                      ||
||	Section 11.9: Relations and Graphs.				||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

%include "Section11-8.m"

||----------------------------------------------------------------------|| 
||	A relation is a set of pairs.					||
||----------------------------------------------------------------------|| 

relation * == set (*,*)

||----------------------------------------------------------------------|| 
||	Operations over relations.					||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	The image of an element under a relation.			||
||----------------------------------------------------------------------|| 

image :: relation * -> * -> set *

image rel val = mapSet snd (filterSet ((=val).fst) rel)

||----------------------------------------------------------------------|| 
||	The image of a set of elements under a relation.		||
||----------------------------------------------------------------------|| 

setImage :: relation * -> set * -> set *

setImage rel = unionSet . mapSet (image rel) 

||----------------------------------------------------------------------|| 
||	The union of a set of sets.					||
||----------------------------------------------------------------------|| 

unionSet :: set (set *) -> set *

unionSet = foldSet union empty

||----------------------------------------------------------------------|| 
||	Add to a set its image under a relation.			||
||----------------------------------------------------------------------|| 

addImage :: relation * -> set * -> set *

addImage rel st = st $union setImage rel st

||----------------------------------------------------------------------|| 
||	Add the children (under the relation isParent) to a set.	||
||----------------------------------------------------------------------|| 

people   :: type
isParent :: relation people

addChildren :: set people -> set people

addChildren = addImage isParent 

||----------------------------------------------------------------------|| 
||	Compose two relations.						||
||----------------------------------------------------------------------|| 

compose :: relation * -> relation * -> relation *

compose rel1 rel2
  =  mapSet outer (filterSet equals (setProduct rel1 rel2))
     where
     equals ((a,b),(c,d)) = (b=c)
     outer  ((a,b),(c,d)) = (a,d)

||----------------------------------------------------------------------|| 
||	The product of two sets.					||
||----------------------------------------------------------------------|| 

setProduct :: set * -> set ** -> set (*,**)

setProduct st1 st2 = unionSet (mapSet (adjoin st1) st2)

||----------------------------------------------------------------------|| 
||	Add an element to each element of a set, forming a set of pairs.||
||----------------------------------------------------------------------|| 

adjoin :: set * -> ** -> set (*,**)

adjoin st el = mapSet (addEl el) st
               where
               addEl el el' = (el',el)

||----------------------------------------------------------------------|| 
||	The transitive closure of a relation.				||
||----------------------------------------------------------------------|| 

tClosure :: relation * -> relation *

tClosure rel = setLimit addGen rel
               where
               addGen rel' = rel' $union compose rel' rel

||----------------------------------------------------------------------|| 
||	Graphs								||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	The connected components of a graph.				||
||----------------------------------------------------------------------|| 

connect :: relation * -> relation *
connect rel = clos $inter solc
              where
              clos = tClosure rel
              solc = inverse clos

||----------------------------------------------------------------------|| 
||	The inverse of a relation -- swap all pairs.			||
||----------------------------------------------------------------------|| 

inverse :: relation * -> relation *
inverse = mapSet swap
          where 
          swap (a,b) = (b,a)


||----------------------------------------------------------------------|| 
||	The equivalence classes of a(n equivalence) relation.		||
||----------------------------------------------------------------------|| 

classes :: relation * -> set (set *)

classes rel 
  = setLimit (addImages rel) start
    where
    start = mapSet sing (elems rel)

||----------------------------------------------------------------------|| 
||	The auxiliary functions used in classes.			||
||----------------------------------------------------------------------|| 

elems :: relation * -> set *

elems rel = mapSet fst rel $union mapSet snd rel

addImages :: relation * -> set (set *) -> set (set *)

addImages rel = mapSet (addImage rel)

||----------------------------------------------------------------------|| 
||	Searching in graphs						||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	The types of the two graph searching algorithms			||
||----------------------------------------------------------------------|| 

breadthFirst :: relation * -> * -> [*]
depthFirst   :: relation * -> * -> [*]

||----------------------------------------------------------------------|| 
||	The descendants v under rel which lie outside st.		||
||----------------------------------------------------------------------|| 

newDescs :: relation * -> set * -> * -> set *
newDescs rel st v = image rel v $diff st

||----------------------------------------------------------------------|| 
||	Breaking the abstraction barrier for sets.			||
||----------------------------------------------------------------------|| 

flatten :: set * -> [*]

||----------------------------------------------------------------------|| 
||	Under the list implementation, we can use			||
||		flatten = id						||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	A list of new descendants.					||
||----------------------------------------------------------------------|| 

findDescs :: relation * -> [*] -> * -> [*]
findDescs rel l v = flatten (newDescs rel (makeSet l) v)

||----------------------------------------------------------------------|| 
||	Finding the limit of a function.				||
||									||
||	generalLimit f x is the first member of the sequence		||
||		x, f x, f (f x), ...					||
||	equal to its successor.						||
||----------------------------------------------------------------------|| 

generalLimit :: (* -> *) -> * -> *
generalLimit f x = x                    , if x = next
                 = generalLimit f next  , otherwise
                   where
                   next = f x

||----------------------------------------------------------------------|| 
||	Breadth first search.						||
||----------------------------------------------------------------------|| 

breadthFirst rel val
	= generalLimit step start
	  where
	  start = [val]
	  step l = l ++ mkset (concat (map (findDescs rel l) l))

||----------------------------------------------------------------------|| 
||	Depth first search.						||
||----------------------------------------------------------------------||

depthSearch :: relation * -> * -> [*] -> [*]

depthFirst rel v = depthSearch rel v []

depthSearch rel v used
	= v : depthList rel (findDescs rel used' v) used'
	  where
	  used' = v:used

depthList rel [] used = [] 

depthList rel (val:rest) used
  = next ++ depthList rel rest (used++next)
    where
    next = []                       , if member used val
         = depthSearch rel val used , otherwise

||----------------------------------------------------------------------|| 
||	From the exercises...						||
||----------------------------------------------------------------------|| 

distance :: relation * -> * -> * -> num



