||----------------------------------------------------------------------||
||                                                                      ||
||	Section 12.2: Calculation Rules					||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||


||----------------------------------------------------------------------|| 
||	An example with pattern matching.				||
||----------------------------------------------------------------------|| 

f1 :: [num] -> [num] -> num
f1 [] y        = 0 
f1 (a:x) []    = 0
f1 (a:x) (b:y) = a+b

exam1 = f1 [1..3] [1..3]

||----------------------------------------------------------------------|| 
||	An example with guards.						||
||----------------------------------------------------------------------|| 

f2 a b c = a    , if a>=b & a>=c
         = b    , if b>=a & b>=c
         = c    , otherwise

exam2 = f2 (2+3) (4-1) (3+9)

||----------------------------------------------------------------------|| 
||	An example with local definitions.				||
||----------------------------------------------------------------------|| 

f3 a b = front l    , if notNil l
       = b          , otherwise
         where
         l = [a..b]

front (c:d:y) = c+d
front [c]     = c

notNil []    = False
notNil (a:x) = True

exam3 = f3 3 5


