||----------------------------------------------------------------------||
||                                                                      ||
||	Section 12.3: List comprehensions revisited			||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	All possible pairs from two lists: first elements from the 	||
||	first list; second from the second.				||
||----------------------------------------------------------------------|| 

pairs :: [*] -> [**] -> [(*,**)]

pairs l m = [ (a,b) | a<-l ; b<-m ]

exam1 = pairs [1,2,3] [4,5] 

||----------------------------------------------------------------------|| 
||	Triangular pairs.						||
||----------------------------------------------------------------------|| 

triangle :: num -> [(num,num)]

triangle n = [ (a,b) | a <- [1..n] ; b <- [1..a] ]

exam2 = triangle 3 

||----------------------------------------------------------------------|| 
||	Pythagorean triples: (a,b,c) such that a*a + b*b = c*c 		||
||----------------------------------------------------------------------|| 

pyTriple n
  = [ (a,b,c) | a <- [2..n] ; b <- [a+1..n] ; c <- [b+1..n] ; 
                a*a + b*b = c*c ]

exam3 = pyTriple 100 

||----------------------------------------------------------------------|| 
||	Examples on calculation.					||
||----------------------------------------------------------------------|| 

isEven :: num -> bool

isEven n = (n mod 2 = 0)

exam4 = [ a+b | a <- [1,2] ; isEven a ; b <- [a..2*a] ]

exam5 = [ (a,b) | a <- [1..3] ; b <- [1..a] ]

exam6 = [ m*m | m <- [1..10] ; m*m<50 ]

||----------------------------------------------------------------------|| 
||	Example: list permutations					||
||----------------------------------------------------------------------|| 

perms :: [*] -> [[*]]

perms [] = [[]]
perms x  = [ a:p | a <- x ; p <- perms (x--[a]) ]

exam7 = perms [2]
exam8 = perms [2,3]
exam9 = perms [1,2,3]

perm :: [*] -> [[*]]

perm []    = [[]]
perm (a:x) = [ p++[a]++q | r <- perm x ;
                           (p,q) <- splits r ]

||----------------------------------------------------------------------|| 
||	All possible splits of a list.					||
||----------------------------------------------------------------------|| 

splits :: [*]->[([*],[*])]

splits []    = [([],[])]
splits (a:x) = ([],a:x) : [ (a:p,q) | (p,q) <- splits x]

||----------------------------------------------------------------------|| 
||	Vectors and Matrices						||
||----------------------------------------------------------------------|| 

vector == [num]

||----------------------------------------------------------------------|| 
||	Scalar product of two vectors.					||
||----------------------------------------------------------------------|| 

scalarProduct :: vector -> vector -> num

scalarProduct l m = sum [ a*b | (a,b) <- zip2 l m ]


||----------------------------------------------------------------------|| 
||	A matrix is a list of rows.					||
||----------------------------------------------------------------------|| 

matrix == [vector]

||----------------------------------------------------------------------|| 
||	Product of matrices.						||
||----------------------------------------------------------------------|| 

matrixProduct :: matrix -> matrix -> matrix

matrixProduct m p
  = [ [scalarProduct r c | c <- columns p] | r <- m ]

||----------------------------------------------------------------------|| 
||	Convert the list of rows to a list of columns.			||
||----------------------------------------------------------------------|| 

columns :: matrix -> matrix

columns y = [ [ z!j | z <- y ] | j<- [0..s] ]
            where 
            s = #(hd y)-1

||----------------------------------------------------------------------|| 
||	From the exercises....						||
||----------------------------------------------------------------------|| 

exam10 = [ a+b | a <- [1..4] ; b <- [2..4] ; a>b ]

subLists,subSequences :: [*] -> [[*]]

exam11 = matrixProduct [[2,3,4],[5,6,-1]] [[1,0],[1,1],[0,-1]]


