||----------------------------------------------------------------------||
||                                                                      ||
||	Section 12.4: Data on demand					||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	Summing fourth powers in a data-directed way.			||
||----------------------------------------------------------------------|| 

sumFourthPowers n = sum (map (^4) [1..n])

||----------------------------------------------------------------------|| 
||	Example: routes through a graph					||
||----------------------------------------------------------------------|| 

%include "../Chapter11/Section11-8.m"
%include "../Chapter11/Section11-9.m"

||----------------------------------------------------------------------|| 
||	Running graph example.						||
||----------------------------------------------------------------------|| 

graphEx = makeSet [(1,2),(1,3),(2,4),(3,5),(5,6),(3,6)]

||----------------------------------------------------------------------|| 
||	Routes from one point to another in a relation (graph).		||
||----------------------------------------------------------------------|| 

routes :: relation * -> * -> * -> [[*]]

routes rel a b
  = [[a]]                               , if a=b
  = [ a:r | c <- nbhrs rel a ;
            r <- routes rel c b ]       , otherwise

||----------------------------------------------------------------------|| 
||	The listof neighbours of a point in a relation.			||
||----------------------------------------------------------------------|| 

nbhrs :: relation * -> * -> [*]

nbhrs rel a = flatten (image rel a)

exam1 = routes graphEx 1 4
exam2 = routes graphEx 1 6 

||----------------------------------------------------------------------|| 
||	Routes through a potentially cyclic graph.			||
||----------------------------------------------------------------------|| 

routesC :: relation * -> * -> * -> [*] -> [[*]]

routesC rel a b l
  = [[a]]                                   , if a=b
  = [ a:r | c <- nbhrs rel a -- l ;
            r <- routesC rel c b (a:l) ]    , otherwise

||----------------------------------------------------------------------|| 
||	From the exercises.						||
||----------------------------------------------------------------------|| 

graphEx2 = makeSet [(1,2),(2,1),(1,3),(2,4),(3,5),(5,6),(3,6)]


