||----------------------------------------------------------------------||
||                                                                      ||
||	Section 12.5: Case study: Parsing expressions			||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	Syntactic types							||
||----------------------------------------------------------------------|| 

var == char

expr ::= Lit num | Var var | Op op expr expr

op   ::= Add | Sub | Mul | Div | Mod

||----------------------------------------------------------------------|| 
||	The type of parsers.						||
||----------------------------------------------------------------------|| 

parse * ** == [*] -> [(**,[*])]

||----------------------------------------------------------------------|| 
||	Some basic parsers						||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	Fail on any input.						||
||----------------------------------------------------------------------|| 

fail :: parse * **

fail in = []

||----------------------------------------------------------------------|| 
||	Succeed, returning the value supplied.				||
||----------------------------------------------------------------------|| 

succeed :: ** -> parse * ** 

succeed val in = [(val,in)]

||----------------------------------------------------------------------|| 
||	token t recognises t as the first value in the input.		||
||----------------------------------------------------------------------|| 

token :: * -> parse * *

token t (a:x) = [(t,x)]   , if t=a
              = []        , otherwise
token t []    = []

||----------------------------------------------------------------------|| 
||	spot whether an element with a particular property is the 	||
||	first element of input.						||
||----------------------------------------------------------------------|| 

spot :: (* -> bool) -> parse * *

spot p (a:x) = [(a,x)]    , if p a
             = []         , otherwise
spot p []    = []

||----------------------------------------------------------------------|| 
||	Examples.							||
||----------------------------------------------------------------------|| 

bracket = token '('
dig     =  spot digit

||----------------------------------------------------------------------|| 
||	Combining parsers						||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	alt p1 p2 recognises anything recogniseed by p1 or by p2.	||
||----------------------------------------------------------------------|| 

alt :: parse * ** -> parse * ** -> parse * **

alt p1 p2 in = p1 in ++ p2 in

exam1 = (bracket $alt dig) "234" 

||----------------------------------------------------------------------|| 
||	Apply one parser then the second to the result(s) of the first.	||
||----------------------------------------------------------------------|| 

then :: parse * ** -> parse * *** -> parse * (**,***)
	
then p1 p2 in 
  = [((y,z),rem2) | (y,rem1) <- p1 in ; 
                    (z,rem2)  <- p2 rem1 ]

||----------------------------------------------------------------------|| 
||	Transform the results of the parses according to the function.	||
||----------------------------------------------------------------------|| 

do :: parse * ** -> (** -> ***) -> parse * ***

do p f in = [ (f x,rem) | (x,rem) <- p in ]

||----------------------------------------------------------------------|| 
||	Recognise a list of objects.					||
||----------------------------------------------------------------------|| 
	
list :: parse * ** -> parse * [**]

list p = (succeed []) $alt
         ((p $then list p) $do convert)
         where
         convert (a,x) = (a:x)

||----------------------------------------------------------------------|| 
||	From the exercises...						||
||----------------------------------------------------------------------|| 

neList   :: parse * ** -> parse * [**]
optional :: parse * ** -> parse * [**]
nTimes :: num -> parse * ** -> parse * [**]

||----------------------------------------------------------------------|| 
||	A parser for expressions					||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	The parser has three components, corresponding to the three	||
||	clauses in the definition of the syntactic type.		||
||----------------------------------------------------------------------|| 

parser :: parse char expr

parser = litParse $alt varParse $alt opExpParse

||----------------------------------------------------------------------|| 
||	Spotting variables.						||
||----------------------------------------------------------------------|| 

varParse :: parse char expr

varParse = spot isVar $do Var

isVar :: char -> bool

isVar x = ('a' <= x & x <= 'z')

||----------------------------------------------------------------------|| 
||	Parsing (fully bracketed) operator applications.		||
||----------------------------------------------------------------------|| 

opExpParse 
  = (token '(' $then
     parser    $then
     spot isOp $then
     parser    $then
     token ')') 
     $do makeExpr

makeExpr (lb,(e1,(bop,(e2,rb)))) = Op (charToOp bop) e1 e2

isOp :: char -> bool
charToOp :: char -> op

||----------------------------------------------------------------------|| 
||	A number is a list of digits with an optional '~' at the front.	||
||----------------------------------------------------------------------|| 

litParse 
  = ((optional (token '~')) $then
     (neList (spot isDigit)))
     $do (charlistToExpr.join) 
     where
     join (l,m) = l++m

isDigit = digit

||----------------------------------------------------------------------|| 
||	From the exercises...						||
||----------------------------------------------------------------------|| 

charlistToExpr :: [char] -> expr

||----------------------------------------------------------------------|| 
||	A grammar for unbracketed expressions.				||
||									||
||	eXpr  ::= num | var | (eXpr op eXpr) |				||
||	          lexpr mop mexpr | mexpr aop eXpr			||
||	lexpr ::= num | var | (eXpr op eXpr)				||
||	mexpr ::= num | var | (eXpr op eXpr) |	lexpr mop mexpr		||
||	mop   ::= '*' | '/' | '\%'					||
||	aop   ::= '+' | '-'						||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	The top-level parser						||
||----------------------------------------------------------------------|| 

topLevel :: parse * ** -> [*] -> **

topLevel p in
  = hd results                 , if results~=[]
  = error "parse unsuccessful" , otherwise
    where
    results = [ found | (found,[]) <- p in ]

||----------------------------------------------------------------------|| 
||	The type of commands.						||
||----------------------------------------------------------------------|| 

command ::= Eval expr | Assign var expr | Null

commandParse :: parse char command

||----------------------------------------------------------------------|| 
||	From the exercises.						||
||----------------------------------------------------------------------|| 

tokenList :: [*] -> parse * [*]

spotWhile :: (* -> bool) -> parse * [*]
