||----------------------------------------------------------------------||
||                                                                      ||
||	Section 13.3: Case study: Simulation				||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

%include "../Simulation/types.m"		|| Simulation types
%include "../Chapter11/Section11-5+6.m"		|| Simulation abstypes
%include "Section13-1.m"			|| Random numbers

||----------------------------------------------------------------------|| 
||	Do the simulation -- give a starting state and list of		||
||	inmess to produce a list of outmess.				||
||----------------------------------------------------------------------|| 

doSimulation :: serverState -> [inmess] -> [outmess]

doSimulation servSt (im:messes)
  = outmesses ++ doSimulation servStNext messes
    where
    (servStNext , outmesses) = simulationStep servSt im

||----------------------------------------------------------------------|| 
||	The random sequence of times.					||
||----------------------------------------------------------------------|| 

randomTimes 
  = map (makeFunction dist) (randomSequence seed)

||----------------------------------------------------------------------|| 
||	The input sequence.						||
||----------------------------------------------------------------------|| 

simulationInput = map2 Yes [1..] randomTimes 

||----------------------------------------------------------------------|| 
||	Test the simulation.						||
||----------------------------------------------------------------------|| 

testSimulation = doSimulation serverStart simulationInput

||----------------------------------------------------------------------|| 
||	A second input sequence.					||
||----------------------------------------------------------------------|| 

simulationInput2 = take 50 simulationInput ++ noes

noes = No : noes

||----------------------------------------------------------------------|| 
||	 A second test.							||
||----------------------------------------------------------------------|| 

testSimulation2 = take 50 (doSimulation serverStart simulationInput2)

||----------------------------------------------------------------------|| 
||	Measuring the total waiting time.				||
||----------------------------------------------------------------------|| 

totalWait :: [outmess] -> num

totalWait = sum . map waitTime
            where
            waitTime (Discharge t w s) = w


