||----------------------------------------------------------------------||
||                                                                      ||
||	Section 13.4: Writing interactive programs			||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	Input and output types.						||
||----------------------------------------------------------------------|| 

input  == [char]
output == [char]
string == [char]

example1 :: input -> output

example1 = lay . map reverse . lines

ex1 = lines "hello\nbard" 
ex2 = lay ["hello","bard"] 

example2 :: input -> output

example2 = lay . map shownum . map (+1) . map numval . lines

example2' :: string -> output

example2' = lay . map shownum . map (+1) . readvals

example3 = lay . map (++"\nAnother?") . map reverse . lines

example4 = ("Enter a string or Control-D\n"++) . example3

||----------------------------------------------------------------------|| 
||	Scanning							||
||----------------------------------------------------------------------|| 

%include "Section13-1.m"

example5 = lay . map shownum . scan' (+) 0

oneStep :: num -> (num,num) -> (num,num)

oneStep val (n,total) = (n+1,total+val)

example6 = lay . map show . scan' oneStep (0,0)

%include "Section13-2.m" -exam1 	|| for scan'

||----------------------------------------------------------------------|| 
||	The average							||
||----------------------------------------------------------------------|| 

aver (0,total) = 0
aver (n,total) = total/n

example7 = lay . map show . map aver . scan' oneStep (0,0)

||----------------------------------------------------------------------|| 
||	Case study: the calculator					||
||----------------------------------------------------------------------|| 

%include "../Chapter12/Section12-5.m" -exam1	|| Parsing functions
%include "../Chapter11/Section11-2-1.m"	-var	|| The store abstype

||----------------------------------------------------------------------|| 
||	Evaluating an expression					||
||----------------------------------------------------------------------|| 

eval :: expr -> store -> num

eval (Lit n) st = n
eval (Var v) st = lookup st v
eval (Op op e1 e2) st
  = opValue op v1 v2
    where
    v1 = eval e1 st
    v2 = eval e2 st

||----------------------------------------------------------------------|| 
||	opValue returns the function associated with an operator.	||
||----------------------------------------------------------------------|| 

opValue :: op -> (num -> num -> num)

||----------------------------------------------------------------------|| 
||	The list of commands to be interpreted is given by		||
||----------------------------------------------------------------------|| 

commList = map (topLevel commandParse) (lines $-)

||----------------------------------------------------------------------|| 
||	To be defined...						||
||----------------------------------------------------------------------|| 

||	commandParse :: string -> command

||----------------------------------------------------------------------|| 
||	Interpreting a list of commands.				||
||----------------------------------------------------------------------|| 

calculate :: [command] -> store -> [string]

calculate ((Eval e):cs) st 
	= show (eval e st) : calculate cs st

calculate ((Assign v e):cs) st
	= ([v] ++ " = " ++ show val) : calculate cs st'
	  where
	  val = eval e st
	  st' = update st v val

calculate (Null:cs) st
	= "Null command" : calculate cs st

calculate [] st = []

||----------------------------------------------------------------------|| 
||	The definition which gives the calculator is			||
||----------------------------------------------------------------------|| 

perform = lay (calculate commList initial)


