||----------------------------------------------------------------------||
||                                                                      ||
||	Section 13.5: A library for interactions			||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

%include "Section13-6.m"	|| The abstype and its implementation

||----------------------------------------------------------------------|| 
||	The type of conditions.						||
||----------------------------------------------------------------------|| 

|| condition * == (input,*) -> bool

||----------------------------------------------------------------------|| 
||	The abstype of interactions.					||
||----------------------------------------------------------------------|| 


|| abstype
||   interact * **
|| with
||   apply :: (* -> **) -> interact * **
||   readI :: (string -> * -> **) -> interact * **
||   write :: (* -> string) -> interact * *
||   sq    :: interact * ** -> interact ** *** -> interact * ***
||   alt   :: condition * -> 
||            interact * ** -> interact * ** -> interact * **
||   run   :: interact * ** -> * -> [char]

||----------------------------------------------------------------------|| 
||	Examples using the abstype.					||
||----------------------------------------------------------------------|| 

oneStep :: interact * num
oneStep =
  readI (const . numval) $sq 
  apply (+1) $sq 
  write shownum

||----------------------------------------------------------------------|| 
||	A while loop							||
||----------------------------------------------------------------------|| 

while ::  condition * -> interact * * -> interact * *

while cond inter 
  = whi
    where
    whi = alt cond (inter $sq whi) null

||----------------------------------------------------------------------|| 
||	A null interaction: no I/O, no change of state.			||
||----------------------------------------------------------------------|| 

null :: interact * *

null = apply id

||----------------------------------------------------------------------|| 
||	End of file?							||
||----------------------------------------------------------------------|| 

eof :: condition *

eof (in,st) = (in=[])

||----------------------------------------------------------------------|| 
||	Redefining earlier examples.					||
||----------------------------------------------------------------------|| 

newExample1 = while ((~).eof) oneStep

newExample5
  = while ((~).eof)
          (readI ((+).numval) $sq 
           write shownum)

||----------------------------------------------------------------------|| 
||	Read a number (n, say) then total the next n numbers.		||
||----------------------------------------------------------------------|| 

sumN = readI (setBound.numval) $sq
       while underBound
             (readI (addToSum.numval) $sq
              apply incCount $sq
              write (shownum.giveSum))

||----------------------------------------------------------------------|| 
||	The state in sumN is designed as an abstype.			||
||----------------------------------------------------------------------|| 

abstype
  state
with
  setBound   :: num -> state -> state
  underBound :: condition state
  addToSum   :: num -> state -> state
  incCount   :: state -> state
  giveSum    :: state -> num
  initialSt  :: state

||----------------------------------------------------------------------|| 
||	Implementing the state for sumN.				||
||----------------------------------------------------------------------|| 

state == (num,num,num)

setBound n (bound,count,sum)      = (n,count,sum)
underBound (in,(bound,count,sum)) = count<bound
addToSum n (bound,count,sum)      = (bound,count,sum+n)
incCount   (bound,count,sum)      = (bound,count+1,sum)
giveSum    (bound,count,sum)      = sum
initialSt                         = (0,0,0)

