||----------------------------------------------------------------------||
||                                                                      ||
||	Section 13.6: Implementing a library for interactions		||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	The type of conditions.						||
||----------------------------------------------------------------------|| 

condition * == (input,*) -> bool

||----------------------------------------------------------------------|| 
||	The abstype of interactions.					||
||----------------------------------------------------------------------|| 


abstype
  interact * **
with
  apply :: (* -> **) -> interact * **
  readI :: (string -> * -> **) -> interact * **
  write :: (* -> string) -> interact * *
  sq    :: interact * ** -> interact ** *** -> interact * ***
  alt   :: condition * -> 
           interact * ** -> interact * ** -> interact * **
  run   :: interact * ** -> * -> [char]

||----------------------------------------------------------------------|| 
||	The implementation type						||
||----------------------------------------------------------------------|| 

interact * ** == (input,*) -> (input,**,output)

string == [char]
input  == [string]
output == [string]

||----------------------------------------------------------------------|| 
||	Note that the input and output types here are lists of lines, 	||
||	rather than the lists of characters given earlier.		||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	The implementation functions.					||
||----------------------------------------------------------------------|| 

||	apply :: (* -> **) -> interact * **

apply f (in,st) = (in, f st , [])

||	readI :: (string -> * -> **) -> interact * **
 
readI f (line:rest,st) = (rest, f line st, [])

||	write :: (* -> string) -> interact * *
 
write f (in,st) = ( in , st , [ f st ] )

||	sq :: interact * ** -> interact ** *** -> interact * ***

sq inter1 inter2 (in,st)
  = (rest2,st2,out1++out2)
    where
    (rest1,st1,out1) = inter1 (in,st)
    (rest2,st2,out2) = inter2 (rest1,st1)

||	alt :: condition * -> 
||		interact * ** -> interact * ** -> interact * **

alt cond inter1 inter2 x
  = inter1 x                 , if cond x
  = inter2 x                 , otherwise

||	run :: interact * ** -> * -> [char]

run inter st
  = lay out
    where
    (rest,st',out) = inter (lines (read stdin) , st)

stdin = "/dev/tty"



