||----------------------------------------------------------------------||
||                                                                      ||
||	Section 14.2: The complexity of calculations			||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	Factorial							||
||----------------------------------------------------------------------|| 


fac :: num -> num

fac 0 = 1
fac n = n * fac (n-1)

||----------------------------------------------------------------------|| 
||	Insertion sort							||
||----------------------------------------------------------------------|| 

iSort []    = []
iSort (a:x) = insert a (iSort x)

insert a [] = [a]
insert a (b:y) = a:b:y        , if a<=b
               = b:insert a y , otherwise

||----------------------------------------------------------------------|| 
||	Quicksort							||
||----------------------------------------------------------------------|| 

qSort []    = []
qSort (a:x) = qSort [y|y<-x;y<=a] ++[a]++ qSort [y|y<-x;y>a]

||----------------------------------------------------------------------|| 
||	Reversing functions						||
||----------------------------------------------------------------------|| 

rev1 []    = []
rev1 (a:x) = rev1 x ++ [a]

rev2          = shunt []

shunt x []    = x
shunt x (a:y) = shunt (a:x) y

||----------------------------------------------------------------------|| 
||	Multiplication by repeated addition.				||
||----------------------------------------------------------------------|| 

mult n 0     = 0
mult n (m+1) = mult n m + n

||----------------------------------------------------------------------|| 
||	`Russian' multiplication 					||
||----------------------------------------------------------------------|| 

russ n 0 = 0
russ n m =  russ (n*n) (m div 2)       , if m mod 2 = 0
         = (russ (n*n) (m div 2))*n    , otherwise

||----------------------------------------------------------------------|| 
||	Merge sort							||
||----------------------------------------------------------------------|| 

mSort l = l     , if len < 2
        = mer (mSort (take m l)) (mSort (drop m l)) , otherwise
          where 
          len = #l
          m   = len div 2

mer (a:x) (b:y) = a : mer x (b:y)    , if a<=b
                = b : mer (a:x) y    , otherwise
mer (a:x) []    = (a:x)
mer []    y     = y

