||----------------------------------------------------------------------||
||                                                                      ||
||	Section 14.6 Avoiding re-computation: memoization		||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	Fibonacci numbers						||
||----------------------------------------------------------------------|| 

fib :: num -> num

fib 0     = 0
fib 1     = 1
fib (n+2) = fib n + fib (n+1)

||----------------------------------------------------------------------|| 
||	A Fibonacci function returning a pair, this and the next number	||
||	as it were.							||
||----------------------------------------------------------------------|| 

fibP :: num -> (num,num)

fibP 0     = (0,1)
fibP (n+1) = (b,a+b)
             where
             (a,b) = fibP n

||----------------------------------------------------------------------|| 
||	The list of Fibonacci numbers					||
||----------------------------------------------------------------------|| 

fibs = 0 : 1 : map2 (+) fibs (tl fibs)

||----------------------------------------------------------------------|| 
||	Dynamic programming						||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	Three algoirthms to find the length of a maximal 		||
||	common subsequence						||
||----------------------------------------------------------------------|| 

mLen :: [*] -> [*] -> num

mLen x []        = 0
mLen [] y        = 0
mLen (a:x) (b:y) = 1 + mLen x y           , if a=b
                 = max2 (mLen x (b:y))
                        (mLen (a:x) y)    , otherwise


maxLen :: [*] -> [*] -> num -> num -> num

maxLen l m 0 j     = 0 
maxLen l m (i+1) 0 = 0
maxLen l m (i+1) (j+1)
  = (maxLen l m i j) + 1		      , if l!i = m!j 
  = max2 (maxLen l m (i+1) j)
         (maxLen l m i (j+1))		 , otherwise


maxTab ::  [*] -> [*] -> [[num]]

maxTab l m
  = result
    where 
    result = [0,0..] : map2 f [0..] result
    f i prev  
        = ans
          where
          ans   = 0 : map2 g [0..] ans
          g j v = (prev!j)+1           , if l!i = m!j
                = max2 v (prev!(j+1))  , otherwise

