||----------------------------------------------------------------------||
||                                                                      ||
||	Section 2.10: Function definitions				||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

string == [char]

||----------------------------------------------------------------------|| 
||	Highest common factor						||
||----------------------------------------------------------------------|| 

hcf :: num -> num -> num
hcf n 0 = n
hcf n m = hcf m n                 , if m > n
        = hcf (n-m) m             , otherwise

||----------------------------------------------------------------------|| 
||	Summing the squares of two numbers.				||
||----------------------------------------------------------------------|| 

sumSquares :: num -> num -> num

sumSquares n m 
  = sqN + sqM
    where
    sqN = n*n
    sqM = m*m

||----------------------------------------------------------------------|| 
||	Printing an average.						||
||----------------------------------------------------------------------|| 

printAverage :: num -> string

printAverage n 
= text ++ averageVal
  where
  text       = "\n     Average " 
  averageVal = rPrintFloat (averageSales n)

rPrintFloat  :: num -> string
averageSales :: num -> num 

||----------------------------------------------------------------------|| 
||	Are numbers even? odd?						||
||----------------------------------------------------------------------|| 

isOdd, isEven :: num -> bool

isOdd 0      = False
isOdd (n+1)  = isEven n

isEven 0     = True
isEven (n+1) = isOdd n

||----------------------------------------------------------------------|| 
||	Which number has the larger square?				||
||----------------------------------------------------------------------|| 

maxsq x y 
  = sqx     , if sqx > sqy
  = sqy     , otherwise
    where
    sqx  = sq x
    sqy  = sq y
    sq z = z*z

