||----------------------------------------------------------------------||
||                                                                      ||
||	Section 2.11: Programming with local definitions		||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

||----------------------------------------------------------------------|| 
||	How many times does the maximum occur?				||
||----------------------------------------------------------------------|| 

maxThreeOccurs :: num -> num -> num -> (num,num)

maxThreeOccurs n m p
  = (max,eqCount)
    where
    max     = maxiThree n m p
    eqCount = equalCount max n m p

||----------------------------------------------------------------------|| 
||	Maximum of three						||
||----------------------------------------------------------------------|| 

maxiThree :: num -> num -> num -> num

maxiThree a b c = max2 a (max2 b c)

||----------------------------------------------------------------------|| 
||	 How many times does a number occur?				||
||----------------------------------------------------------------------|| 

equalCount :: num -> num -> num -> num -> num

equalCount val n m p
  = isN + isM + isP
    where
    isN = 1  , if n=val
        = 0  , otherwise
    isM = 1  , if m=val
        = 0  , otherwise
    isP = 1  , if p=val
        = 0  , otherwise

||----------------------------------------------------------------------|| 
||	Alternatively ....						||
||----------------------------------------------------------------------|| 

equalCount' :: num -> num -> num -> num -> num

equalCount' val n m p
  = isVal n  + isVal m + isVal p
    where
    isVal x = 1  , if x=val
            = 0  , otherwise



