||----------------------------------------------------------------------||
||                                                                      ||
||	Section 2.12: Quadratic equations				||
||                                                                      ||
||	(c) Simon Thompson, 1995.					||
||                                                                      ||
||----------------------------------------------------------------------||

string == [char]

||----------------------------------------------------------------------|| 
||	Finding the single root,					||
||----------------------------------------------------------------------|| 

oneRoot :: num -> num -> num -> num

oneRoot a b c = -b/(2*a)

||----------------------------------------------------------------------|| 
||	... and two real roots.						||
||----------------------------------------------------------------------|| 

twoRoots :: num -> num -> num -> (num,num)

twoRoots a b c
  = (d-e,d+e)
    where
    d = -b/(2*a)
    e = sqrt(b^2-4*a*c)/(2*a)

||----------------------------------------------------------------------|| 
||	Top-level function.						||
||----------------------------------------------------------------------|| 

quadAnalyse :: num -> num -> num -> string

quadAnalyse a b c
  = header a b c ++ roots a b c

||----------------------------------------------------------------------|| 
||	Printing the header.						||
||----------------------------------------------------------------------|| 

header :: num -> num -> num -> string

header a b c
  = "The quadratic equation\n\n\t" ++
    shownum a ++ "*X^2 + " ++ 
    shownum b ++ "*X + " ++
    shownum c ++ " = 0" ++ "\n\nhas "

||----------------------------------------------------------------------|| 
||	Printing the roots.						||
||----------------------------------------------------------------------|| 

roots :: num -> num -> num -> string

roots a b c
  = "two roots: " ++ shownum f ++ " " ++ shownum s      
                 , if b^2 > 4*a*c
  = "one root: " ++ shownum (oneRoot a b c)             
                 , if b^2 = 4*a*c
  = "no roots"   , otherwise
    where
    (f,s) = twoRoots a b c

||----------------------------------------------------------------------|| 
||	Error handling version of oneRoot				||
||----------------------------------------------------------------------|| 

oneRoot' :: num -> num -> num -> num

oneRoot' a b c 
  = -b/(2*a)                           , if a ~= 0
  = error "oneRoot called with a=0"    , otherwise




