||----------------------------------------------------------------------|| 
||									||
||      Section 2.2: Programming with integers                          ||
||									||
||	(c) Simon Thompson, 1995.					||
||									||
||----------------------------------------------------------------------|| 

||----------------------------------------------------------------------|| 
||	The function sales is specified to be a function from numbers	||
||	to numbers.							||
||----------------------------------------------------------------------|| 

sales :: num -> num


||----------------------------------------------------------------------|| 
||	Total sales for a period.					||
||----------------------------------------------------------------------|| 

totalSales :: num -> num

totalSales n
  = sales 0                        , if n=0
  = totalSales (n-1) + sales n     , otherwise

||----------------------------------------------------------------------|| 
||	Maximum sales in a period.					||
||----------------------------------------------------------------------|| 

maxSales :: num -> num

maxSales n
  = sales 0               , if n=0
  = maxSales (n-1)        , if maxSales (n-1) >= sales n
  = sales n               , otherwise

||----------------------------------------------------------------------|| 
||	Alternative definition of maximum sales function.		||
||----------------------------------------------------------------------|| 

maxSales' :: num -> num

maxSales' n
  = sales 0                              , if n=0
  = maxi (maxSales' (n-1)) (sales n)     , otherwise

||----------------------------------------------------------------------|| 
||	To use the definition of the maxi function, include the file	||
||	containing the appropriate definitions. See Chapter 10 for	||
||	further details.						||
||----------------------------------------------------------------------|| 

%include "Chapter1"
